/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedProjectionResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.PreparedQueryImpl;
import org.apache.openjpa.jdbc.kernel.PreparedResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.SQLProjectionResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.SQLStoreQuery;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.QueryExpressionsState;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.ResultSetResult;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.jdbc.sql.SelectExecutor;
import org.apache.openjpa.jdbc.sql.SelectImpl;
import org.apache.openjpa.kernel.ExpressionStoreQuery;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.InternalException;

public class PreparedSQLStoreQuery
extends SQLStoreQuery {
    private static final long serialVersionUID = 1L;
    private PreparedQueryImpl _cached;

    public PreparedSQLStoreQuery(JDBCStore store) {
        super(store);
    }

    @Override
    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subclasses) {
        return new PreparedSQLExecutor(this, meta);
    }

    public boolean setQuery(Object query) {
        if (!(query instanceof PreparedQueryImpl)) {
            throw new InternalException(String.valueOf(query.getClass()) + " not recognized");
        }
        this._cached = (PreparedQueryImpl)query;
        return true;
    }

    PreparedQueryImpl getPreparedQuery() {
        return this._cached;
    }

    public static class PreparedSQLExecutor
    extends ExpressionStoreQuery.AbstractExpressionExecutor {
        private final ClassMetaData _meta;
        private final PreparedSQLStoreQuery _query;

        public PreparedSQLExecutor(PreparedSQLStoreQuery q, ClassMetaData candidate) {
            this._meta = candidate;
            this._query = q;
        }

        public QueryExpressions[] getQueryExpressions() {
            return this._query.getPreparedQuery().getQueryExpressions();
        }

        public Class[] getProjectionTypes(StoreQuery q) {
            return this._query.getPreparedQuery().getProjectionTypes();
        }

        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            Object rop;
            PreparedSQLStoreQuery psq = (PreparedSQLStoreQuery)q;
            PreparedQueryImpl pq = psq.getPreparedQuery();
            JDBCStore store = psq.getStore();
            DBDictionary dict = store.getDBDictionary();
            SQLBuffer buf = new SQLBuffer(dict).append(pq.getTargetQuery());
            Connection conn = store.getConnection();
            JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)q.getContext().getFetchConfiguration();
            Statement stmnt = null;
            try {
                stmnt = !range.lrs ? buf.prepareStatement(conn) : buf.prepareStatement(conn, fetch, -1, -1);
                int index = 0;
                for (Object param : params) {
                    dict.setUnknown((PreparedStatement)stmnt, ++index, param, null);
                }
                dict.setTimeouts((PreparedStatement)stmnt, fetch, false);
                ResultSet rs = stmnt.executeQuery();
                SelectImpl cachedSelect = pq.getSelect();
                Result res = cachedSelect.getEagerResult(conn, (PreparedStatement)stmnt, rs, store, fetch, false, null);
                if (this.getQueryExpressions()[0].projections.length > 0) {
                    ExpContext ctx = new ExpContext(store, params, fetch);
                    QueryExpressionsState state = (QueryExpressionsState)this.getQueryExpressions()[0].state;
                    rop = new PreparedProjectionResultObjectProvider((SelectExecutor)cachedSelect, this.getQueryExpressions(), new QueryExpressionsState[]{state}, ctx, res);
                } else {
                    rop = q.getContext().getCandidateType() != null ? new PreparedResultObjectProvider(cachedSelect, (ClassMapping)this._meta, store, fetch, res) : new SQLProjectionResultObjectProvider(store, fetch, (ResultSetResult)res, q.getContext().getResultType());
                }
            }
            catch (SQLException se) {
                if (stmnt != null) {
                    try {
                        stmnt.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw SQLExceptions.getStore(se, dict);
            }
            if (range.start != 0L || range.end != Long.MAX_VALUE) {
                rop = new RangeResultObjectProvider((ResultObjectProvider)rop, range.start, range.end);
            }
            return rop;
        }

        public synchronized Object[] toParameterArray(StoreQuery q, Map userParams) {
            Object[] array = new Object[userParams.size()];
            Set userSet = userParams.entrySet();
            for (Map.Entry userEntry : userSet) {
                int idx = (Integer)userEntry.getKey();
                array[idx] = userEntry.getValue();
            }
            return array;
        }
    }
}

