/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Schemas;

public class StoredProcedure {
    private DBIdentifier _catalog;
    private DBIdentifier _schema;
    private DBIdentifier _name;
    private List<Column> _cols = new ArrayList<Column>();
    private List<String> _params = new ArrayList<String>();
    private List<String> _sql = new ArrayList<String>();
    private final boolean _fromDatabase;

    public StoredProcedure(String name) {
        this._name = DBIdentifier.newProcedure(name);
        this._fromDatabase = false;
    }

    public StoredProcedure(ResultSet rs) throws SQLException {
        this._fromDatabase = true;
        int i = 0;
        do {
            if (i == 0) {
                this._catalog = DBIdentifier.newCatalog(rs.getString(1));
                this._schema = DBIdentifier.newSchema(rs.getString(2));
                this._name = DBIdentifier.newIdentifier(rs.getString(3), DBIdentifier.DBIdentifierType.PROCEDURE, false);
            }
            Column col = new Column();
            this._cols.add(col);
            col.setIdentifier(DBIdentifier.newColumn(rs.getString(4)));
            col.setFlag(rs.getShort(5), true);
            col.setType(rs.getInt(6));
            col.setTypeIdentifier(DBIdentifier.newConstant(rs.getString(7)));
            col.setPrecision(rs.getInt(8));
            col.setSize(rs.getInt(9));
            col.setScale(rs.getInt(10));
            col.setRadix(rs.getShort(11));
            col.setNullability(rs.getShort(12));
            col.setComment(rs.getString(13));
            col.setIndex(i);
            this._params.add(col.getIdentifier().getName() + " " + col.getTypeIdentifier().getName());
            ++i;
        } while (rs.next());
    }

    public void setCatalog(DBIdentifier catalog) {
        this._catalog = catalog;
    }

    public void setSchema(DBIdentifier schema) {
        this._schema = schema;
    }

    public void setName(String name) {
        this._name = DBIdentifier.newIdentifier(name, DBIdentifier.DBIdentifierType.PROCEDURE, false);
    }

    public Column[] getInColumns() {
        return this.getColumns((short)1);
    }

    public Column[] getInOutColumns() {
        return this.getColumns((short)2);
    }

    public Column[] getOutColumns() {
        return this.getColumns((short)4);
    }

    public Column[] getReturnColumns() {
        return this.getColumns((short)5);
    }

    public Column[] getResultColumns() {
        return this.getColumns((short)3);
    }

    public Column[] getColumns() {
        return this._cols.toArray(new Column[this._cols.size()]);
    }

    int countColumn(short flag) {
        int count = 0;
        for (Column col : this._cols) {
            if (!col.getFlag(flag)) continue;
            ++count;
        }
        return count;
    }

    Column[] getColumns(short flag) {
        ArrayList<Column> cols = null;
        for (Column col : this._cols) {
            if (!col.getFlag(flag)) continue;
            if (cols == null) {
                cols = new ArrayList<Column>();
            }
            cols.add(col);
        }
        return cols == null ? Schemas.EMPTY_COLUMNS : cols.toArray(new Column[cols.size()]);
    }

    public String getName() {
        return this._name.getName();
    }

    public StoredProcedure addParameter(String var, String typeName) {
        return this.addParameter(PARAM.IN, var, typeName);
    }

    public StoredProcedure addParameter(PARAM param, String var, String typeName) {
        this.assertMutable();
        this._params.add(param + " " + var + " " + typeName);
        return this;
    }

    public StoredProcedure setLanguage(String language) {
        this._sql.add("LANGUAGE " + language);
        return this;
    }

    public String getCreateSQL() {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE PROCEDURE ");
        buf.append(this._name);
        buf.append(" (");
        Iterator<String> p = this._params.iterator();
        while (p.hasNext()) {
            buf.append(p.next());
            buf.append(p.hasNext() ? "," : "");
        }
        buf.append(") ");
        for (String s : this._sql) {
            buf.append(s).append(" ");
        }
        return buf.toString().trim();
    }

    public String getDropSQL() {
        return "DROP PROCEDURE " + this._name;
    }

    public String getCallSQL() {
        StringBuilder buf = new StringBuilder();
        buf.append("CALL ");
        buf.append(this._name);
        buf.append(" (");
        Iterator<String> p = this._params.iterator();
        while (p.hasNext()) {
            p.next();
            buf.append("?");
            if (!p.hasNext()) continue;
            buf.append(",");
        }
        buf.append(")");
        return buf.toString().trim();
    }

    public StoredProcedure setSQL(SQL sql) {
        switch (sql) {
            case CONTAINS: {
                this._sql.add("CONTAINS SQL");
                break;
            }
            case NONE: {
                this._sql.add("NO SQL");
                break;
            }
            case MODIFY: {
                this._sql.add("MODIFIES SQL DATA");
                break;
            }
            case READ: {
                this._sql.add("READS SQL DATA");
            }
        }
        return this;
    }

    public StoredProcedure setParameterStyle(String lang) {
        this._sql.add("PARAMETER STYLE " + lang);
        return this;
    }

    public StoredProcedure setExternalName(Class<?> cls, String method, Class<?> ... paramTypes) {
        this.assertStaticMethod(cls, method, paramTypes);
        this._sql.add("EXTERNAL NAME '" + cls.getName() + "." + method + "'");
        return this;
    }

    public StoredProcedure setResult(int i) {
        return this.setResult(i, false);
    }

    public StoredProcedure setResult(int i, boolean dynamic) {
        this.assertMutable();
        this._sql.add((dynamic ? "DYNAMIC " : "") + "RESULT SETS " + i);
        return this;
    }

    private void assertStaticMethod(Class<?> cls, String method, Class<?> ... paramTypes) {
        try {
            Method m = cls.getMethod(method, paramTypes);
            if (m == null || !Modifier.isStatic(m.getModifiers())) {
                throw new RuntimeException("No static method " + method + " with arguments " + Arrays.toString(paramTypes) + " in " + cls);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("No static method " + method + " with arguments " + Arrays.toString(paramTypes) + " in " + cls, ex);
        }
    }

    private void assertMutable() {
        if (this._fromDatabase) {
            throw new IllegalStateException(this + " is not mutable");
        }
    }

    public String toString() {
        return this.getName();
    }

    public static enum SQL {
        NONE,
        MODIFY,
        READ,
        CONTAINS;

    }

    public static enum PARAM {
        UNKNOW,
        IN,
        INOUT,
        RESULT,
        OUT,
        RETURN;

    }
}

