/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.AbstractSQLServerDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.JavaTypes;

public class SQLServerDictionary
extends AbstractSQLServerDictionary {
    public static final String VENDOR_MICROSOFT = "microsoft";
    public static final String VENDOR_NETDIRECT = "netdirect";
    public static final String VENDOR_JTDS = "jtds";
    private static final Localizer _loc = Localizer.forPackage(SQLServerDictionary.class);
    private String schemaCase = "preserve";
    public boolean uniqueIdentifierAsVarbinary = true;

    public SQLServerDictionary() {
        this.platform = "Microsoft SQL Server";
        this.forUpdateClause = null;
        this.tableForUpdateClause = "WITH (UPDLOCK)";
        this.supportsNullTableForGetColumns = false;
        this.requiresAliasForSubselect = true;
        this.stringLengthFunction = "LEN({0})";
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        String props;
        super.connectedConfiguration(conn);
        boolean requiresWarnings = true;
        DatabaseMetaData meta = conn.getMetaData();
        String driverName = meta.getDriverName();
        String url = meta.getURL();
        if (this.driverVendor == null) {
            if (driverName != null) {
                if (driverName.startsWith("Microsoft SQL Server")) {
                    this.driverVendor = VENDOR_MICROSOFT;
                    if (meta.getDatabaseMajorVersion() >= 9) {
                        this.supportsXMLColumn = true;
                    }
                    if (meta.getDriverMajorVersion() >= 2) {
                        requiresWarnings = false;
                    }
                } else {
                    if ("NetDirect JSQLConnect".equals(driverName)) {
                        this.driverVendor = VENDOR_NETDIRECT;
                    } else if (driverName.startsWith("jTDS")) {
                        this.driverVendor = VENDOR_JTDS;
                    } else if ("SQLServer".equals(driverName)) {
                        this.driverVendor = url != null && url.startsWith("jdbc:microsoft:sqlserver:") ? VENDOR_MICROSOFT : (url != null && url.startsWith("jdbc:datadirect:sqlserver:") ? "datadirect" : "other");
                    }
                    if (driverName.indexOf(this.platform) != -1) {
                        int version;
                        String versionString = driverName.substring(this.platform.length() + 1);
                        if (versionString.indexOf(" ") != -1) {
                            versionString = versionString.substring(0, versionString.indexOf(" "));
                        }
                        if ((version = Integer.parseInt(versionString)) >= 2005) {
                            this.supportsXMLColumn = true;
                        }
                    }
                }
            } else {
                this.driverVendor = "other";
            }
        }
        if ((VENDOR_MICROSOFT.equalsIgnoreCase(this.driverVendor) && requiresWarnings || "datadirect".equalsIgnoreCase(this.driverVendor)) && url.toLowerCase().indexOf("selectmethod=cursor") == -1) {
            this.log.warn((Object)_loc.get("sqlserver-cursor", (Object)url));
        }
        if ((props = this.conf.getConnectionFactoryProperties()) != null && VENDOR_MICROSOFT.equalsIgnoreCase(this.driverVendor) && requiresWarnings && props.toLowerCase().indexOf("maxcachedstatements=0") == -1) {
            this.log.warn((Object)_loc.get("sqlserver-cachedstmnts"));
        }
    }

    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        Column[] cols = super.getColumns(meta, catalog, schemaName, tableName, columnName, conn);
        for (int i = 0; cols != null && i < cols.length; ++i) {
            String typeName = cols[i].getTypeName();
            if (typeName == null) continue;
            if ("NVARCHAR".equals(typeName = typeName.toUpperCase())) {
                cols[i].setType(12);
                continue;
            }
            if ("UNIQUEIDENTIFIER".equals(typeName)) {
                if (this.uniqueIdentifierAsVarbinary) {
                    cols[i].setType(-3);
                    continue;
                }
                cols[i].setType(12);
                continue;
            }
            if ("NCHAR".equals(typeName)) {
                cols[i].setType(1);
                continue;
            }
            if (!"NTEXT".equals(typeName)) continue;
            cols[i].setType(2005);
        }
        return cols;
    }

    protected void appendLength(SQLBuffer buf, int type) {
        if (type == 12) {
            buf.append("(").append(Integer.toString(this.characterColumnSize)).append(")");
        }
    }

    public void appendXmlComparison(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs, boolean lhsxml, boolean rhsxml) {
        super.appendXmlComparison(buf, op, lhs, rhs, lhsxml, rhsxml);
        if (lhsxml && rhsxml) {
            this.appendXmlComparison2(buf, op, lhs, rhs);
        } else if (lhsxml) {
            this.appendXmlComparison1(buf, op, lhs, rhs);
        } else {
            this.appendXmlComparison1(buf, op, rhs, lhs);
        }
    }

    private void appendXmlComparison1(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        boolean castrhs = rhs.isConstant();
        if (castrhs) {
            this.appendXmlValue(buf, lhs);
        } else {
            this.appendXmlExist(buf, lhs);
        }
        buf.append(" ").append(op).append(" ");
        if (castrhs) {
            rhs.appendTo(buf);
        } else {
            buf.append("sql:column(\"");
            rhs.appendTo(buf);
            buf.append("\")").append("]') = 1");
        }
    }

    private void appendXmlExist(SQLBuffer buf, FilterValue lhs) {
        buf.append(lhs.getColumnAlias(lhs.getFieldMapping().getColumns()[0])).append(".exist('").append("/*[");
        lhs.appendTo(buf);
    }

    private void appendXmlComparison2(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        this.appendXmlValue(buf, lhs);
        buf.append(" ").append(op).append(" ");
        this.appendXmlValue(buf, rhs);
    }

    private void appendXmlValue(SQLBuffer buf, FilterValue val) {
        Class rc = Filters.wrap((Class)val.getType());
        int type = this.getJDBCType(JavaTypes.getTypeCode((Class)rc), false);
        boolean isXmlAttribute = val.getXmlMapping() == null ? false : val.getXmlMapping().isXmlAttribute();
        buf.append(val.getColumnAlias(val.getFieldMapping().getColumns()[0])).append(".value(").append("'(/*/");
        val.appendTo(buf);
        if (!isXmlAttribute) {
            buf.append("/text()");
        }
        buf.append(")[1]','").append(this.getTypeName(type));
        this.appendLength(buf, type);
        buf.append("')");
    }

    public String getSchemaCase() {
        return this.schemaCase;
    }
}

