/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;

public abstract class AbstractDB2Dictionary
extends DBDictionary {
    public AbstractDB2Dictionary() {
        this.numericTypeName = "DOUBLE";
        this.bitTypeName = "SMALLINT";
        this.smallintTypeName = "SMALLINT";
        this.tinyintTypeName = "SMALLINT";
        this.longVarbinaryTypeName = "BLOB";
        this.varbinaryTypeName = "BLOB";
        this.stringLengthFunction = "LENGTH({0})";
        this.concatenateFunction = "(CAST({0} AS VARCHAR(1000)))||(CAST({1} AS VARCHAR(1000)))";
        this.trimLeadingFunction = "LTRIM({0})";
        this.trimTrailingFunction = "RTRIM({0})";
        this.trimBothFunction = "LTRIM(RTRIM({0}))";
        this.forUpdateClause = "FOR UPDATE WITH RR";
        this.supportsLockingWithDistinctClause = false;
        this.supportsLockingWithMultipleTables = false;
        this.supportsLockingWithOrderClause = false;
        this.supportsLockingWithOuterJoin = false;
        this.supportsLockingWithInnerJoin = false;
        this.supportsLockingWithSelectRange = true;
        this.supportsCaseConversionForLob = true;
        this.requiresAutoCommitForMetaData = true;
        this.requiresAliasForSubselect = true;
        this.supportsAutoAssign = true;
        this.autoAssignClause = "GENERATED BY DEFAULT AS IDENTITY";
        this.lastGeneratedKeyQuery = "VALUES(IDENTITY_VAL_LOCAL())";
        this.crossJoinClause = "JOIN";
        this.requiresConditionForCrossJoin = true;
    }

    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("(LOCATE(CAST((");
        find.appendTo(buf);
        buf.append(") AS VARCHAR(1000)), CAST((");
        str.appendTo(buf);
        buf.append(") AS VARCHAR(1000))");
        if (start != null) {
            buf.append(", CAST((");
            start.appendTo(buf);
            buf.append(") AS INTEGER) + 1");
        }
        buf.append(") - 1)");
    }

    public void substring(SQLBuffer buf, FilterValue str, FilterValue start, FilterValue end) {
        buf.append("SUBSTR(CAST((");
        str.appendTo(buf);
        buf.append(") AS VARCHAR(1000)), CAST((");
        start.appendTo(buf);
        buf.append(") AS INTEGER) + 1");
        if (end != null) {
            buf.append(", CAST((");
            end.appendTo(buf);
            buf.append(") AS INTEGER) - CAST((");
            start.appendTo(buf);
            buf.append(") AS INTEGER)");
        }
        buf.append(")");
    }
}

