/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.strats.InValueDiscriminatorStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class ClassNameDiscriminatorStrategy
extends InValueDiscriminatorStrategy {
    private static final Localizer _loc = Localizer.forPackage((Class)ClassNameDiscriminatorStrategy.class);
    public static final String ALIAS = "class-name";

    public String getAlias() {
        return ALIAS;
    }

    protected int getJavaType() {
        return 9;
    }

    protected Object getDiscriminatorValue(ClassMapping cls) {
        return cls.getDescribedType().getName();
    }

    protected Class getClass(Object val, JDBCStore store) throws ClassNotFoundException {
        ClassLoader loader = this.getClassLoader(store);
        return Class.forName((String)val, true, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSubclasses(JDBCStore store) throws SQLException, ClassNotFoundException {
        if (this.isFinal) {
            this.disc.setSubclassesLoaded(true);
            return;
        }
        Column col = this.disc.getColumns()[0];
        DBDictionary dict = store.getDBDictionary();
        SQLBuffer select = dict.toSelect(new SQLBuffer(dict).append(col), store.getFetchConfiguration(), new SQLBuffer(dict).append(col.getTable()), null, null, null, null, true, false, 0L, Long.MAX_VALUE);
        Log log = this.disc.getMappingRepository().getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)_loc.get("load-subs", (Object)col.getTable().getFullName()));
        }
        ClassLoader loader = this.getClassLoader(store);
        Connection conn = store.getConnection();
        PreparedStatement stmnt = null;
        ResultSet rs = null;
        try {
            stmnt = select.prepareStatement(conn);
            rs = stmnt.executeQuery();
            while (rs.next()) {
                String className = dict.getString(rs, 1);
                if (StringUtils.isEmpty((String)className)) {
                    throw new ClassNotFoundException(_loc.get("no-class-name", (Object)this.disc.getClassMapping(), (Object)col).getMessage());
                }
                Class.forName(className, true, loader);
            }
            this.disc.setSubclassesLoaded(true);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
            try {
                conn.close();
            }
            catch (SQLException se) {}
        }
    }

    private ClassLoader getClassLoader(JDBCStore store) {
        return store.getConfiguration().getClassResolverInstance().getClassLoader(this.disc.getClassMapping().getDescribedType(), store.getContext().getClassLoader());
    }
}

