/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Cache;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.spi.LoadState;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DelegatingBrokerFactory;
import org.apache.openjpa.kernel.DelegatingFetchConfiguration;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.FetchPlanImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistenceUtil;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryResultCache;
import org.apache.openjpa.persistence.QueryResultCacheImpl;
import org.apache.openjpa.persistence.StoreCache;
import org.apache.openjpa.persistence.StoreCacheImpl;
import org.apache.openjpa.persistence.criteria.CriteriaBuilderImpl;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaBuilder;
import org.apache.openjpa.persistence.meta.MetamodelImpl;
import org.apache.openjpa.persistence.query.OpenJPAQueryBuilder;
import org.apache.openjpa.persistence.query.QueryBuilderImpl;

public class EntityManagerFactoryImpl
implements OpenJPAEntityManagerFactory,
OpenJPAEntityManagerFactorySPI,
Closeable,
PersistenceUnitUtil {
    private static final Localizer _loc = Localizer.forPackage(EntityManagerFactoryImpl.class);
    private DelegatingBrokerFactory _factory = null;
    private transient Constructor<FetchPlan> _plan = null;
    private transient StoreCache _cache = null;
    private transient QueryResultCache _queryCache = null;
    private transient MetamodelImpl _metaModel;

    public EntityManagerFactoryImpl() {
    }

    public EntityManagerFactoryImpl(BrokerFactory factory) {
        this.setBrokerFactory(factory);
    }

    public BrokerFactory getBrokerFactory() {
        return this._factory.getDelegate();
    }

    public void setBrokerFactory(BrokerFactory factory) {
        this._factory = new DelegatingBrokerFactory(factory, PersistenceExceptions.TRANSLATOR);
    }

    @Override
    public OpenJPAConfiguration getConfiguration() {
        return this._factory.getConfiguration();
    }

    @Override
    public Map<String, Object> getProperties() {
        Map<String, Object> props = this._factory.getProperties();
        props.putAll(this.createEntityManager().getProperties());
        return props;
    }

    @Override
    public Object putUserObject(Object key, Object val) {
        return this._factory.putUserObject(key, val);
    }

    @Override
    public Object getUserObject(Object key) {
        return this._factory.getUserObject(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreCache getStoreCache() {
        this._factory.lock();
        try {
            if (this._cache == null) {
                OpenJPAConfiguration conf = this._factory.getConfiguration();
                this._cache = new StoreCacheImpl(this, conf.getDataCacheManagerInstance().getSystemDataCache());
            }
            StoreCache storeCache = this._cache;
            return storeCache;
        }
        finally {
            this._factory.unlock();
        }
    }

    @Override
    public StoreCache getStoreCache(String cacheName) {
        return new StoreCacheImpl(this, this._factory.getConfiguration().getDataCacheManagerInstance().getDataCache(cacheName, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultCache getQueryResultCache() {
        this._factory.lock();
        try {
            if (this._queryCache == null) {
                this._queryCache = new QueryResultCacheImpl(this._factory.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache());
            }
            QueryResultCache queryResultCache = this._queryCache;
            return queryResultCache;
        }
        finally {
            this._factory.unlock();
        }
    }

    @Override
    public OpenJPAEntityManagerSPI createEntityManager() {
        return this.createEntityManager(null);
    }

    @Override
    public OpenJPAEntityManagerSPI createEntityManager(Map props) {
        String cf2Name;
        int retainMode;
        boolean managed;
        String str;
        String pass;
        if (props == null) {
            props = Collections.EMPTY_MAP;
        } else if (!props.isEmpty()) {
            props = new HashMap(props);
        }
        OpenJPAConfiguration conf = this.getConfiguration();
        Log log = conf.getLog("openjpa.Runtime");
        String user = (String)Configurations.removeProperty("ConnectionUserName", props);
        if (user == null) {
            user = conf.getConnectionUserName();
        }
        if ((pass = (String)Configurations.removeProperty("ConnectionPassword", props)) == null) {
            pass = conf.getConnectionPassword();
        }
        if ((str = (String)Configurations.removeProperty("TransactionMode", props)) == null) {
            managed = conf.isTransactionModeManaged();
        } else {
            Value val = conf.getValue("TransactionMode");
            managed = Boolean.parseBoolean(val.unalias(str));
        }
        Object obj = Configurations.removeProperty("ConnectionRetainMode", props);
        if (obj instanceof Number) {
            retainMode = ((Number)obj).intValue();
        } else if (obj == null) {
            retainMode = conf.getConnectionRetainModeConstant();
        } else {
            Value val = conf.getValue("ConnectionRetainMode");
            try {
                retainMode = Integer.parseInt(val.unalias((String)obj));
            }
            catch (Exception e) {
                throw new ArgumentException(_loc.get("bad-em-prop", "openjpa.ConnectionRetainMode", obj), new Throwable[]{e}, obj, true);
            }
        }
        String cfName = (String)Configurations.removeProperty("jtaDataSource", props);
        if (cfName == null) {
            cfName = (String)Configurations.removeProperty("ConnectionFactoryName", props);
        }
        if ((cf2Name = (String)Configurations.removeProperty("nonJtaDataSource", props)) == null) {
            cf2Name = (String)Configurations.removeProperty("ConnectionFactory2Name", props);
        }
        if (log != null && log.isTraceEnabled()) {
            if (StringUtils.isNotEmpty(cfName)) {
                log.trace("Found ConnectionFactoryName from props: " + cfName);
            }
            if (StringUtils.isNotEmpty(cf2Name)) {
                log.trace("Found ConnectionFactory2Name from props: " + cf2Name);
            }
        }
        this.validateCfNameProps(conf, cfName, cf2Name);
        Broker broker = this._factory.newBroker(user, pass, managed, retainMode, false, cfName, cf2Name);
        broker.setAutoDetach(2, true);
        broker.setAutoDetach(16, true);
        broker.setDetachedNew(false);
        EntityManagerImpl em = this.newEntityManagerImpl(broker);
        Set entrySet = props.entrySet();
        for (Map.Entry entry : entrySet) {
            em.setProperty(entry.getKey().toString(), entry.getValue());
        }
        if (log != null && log.isTraceEnabled()) {
            log.trace(this + " created EntityManager " + em + ".");
        }
        return em;
    }

    protected EntityManagerImpl newEntityManagerImpl(Broker broker) {
        return new EntityManagerImpl(this, broker);
    }

    @Override
    public void addLifecycleListener(Object listener, Class ... classes) {
        this._factory.addLifecycleListener(listener, classes);
    }

    @Override
    public void removeLifecycleListener(Object listener) {
        this._factory.removeLifecycleListener(listener);
    }

    @Override
    public void addTransactionListener(Object listener) {
        this._factory.addTransactionListener(listener);
    }

    @Override
    public void removeTransactionListener(Object listener) {
        this._factory.removeTransactionListener(listener);
    }

    @Override
    public void close() {
        Log log = this._factory.getConfiguration().getLog("openjpa.Runtime");
        if (log.isTraceEnabled()) {
            log.trace(this + ".close() invoked.");
        }
        this._factory.close();
    }

    @Override
    public boolean isOpen() {
        return !this._factory.isClosed();
    }

    public int hashCode() {
        return this._factory == null ? 0 : this._factory.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this._factory == null) {
            return false;
        }
        return this._factory.equals(((EntityManagerFactoryImpl)other)._factory);
    }

    FetchPlan toFetchPlan(Broker broker, FetchConfiguration fetch) {
        if (fetch == null) {
            return null;
        }
        if (fetch instanceof DelegatingFetchConfiguration) {
            fetch = ((DelegatingFetchConfiguration)fetch).getInnermostDelegate();
        }
        try {
            if (this._plan == null) {
                Class<?> storeType = broker == null ? null : broker.getStoreManager().getInnermostDelegate().getClass();
                Class cls = this._factory.getConfiguration().getStoreFacadeTypeRegistry().getImplementation(FetchPlan.class, storeType, FetchPlanImpl.class);
                this._plan = cls.getConstructor(FetchConfiguration.class);
            }
            return this._plan.newInstance(fetch);
        }
        catch (InvocationTargetException ite) {
            throw PersistenceExceptions.toPersistenceException(ite.getTargetException());
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    @Override
    public Cache getCache() {
        this._factory.assertOpen();
        return this.getStoreCache();
    }

    @Override
    public OpenJPACriteriaBuilder getCriteriaBuilder() {
        return new CriteriaBuilderImpl().setMetaModel(this.getMetamodel());
    }

    @Override
    public OpenJPAQueryBuilder getDynamicQueryBuilder() {
        return new QueryBuilderImpl(this);
    }

    @Override
    public Set<String> getSupportedProperties() {
        return this._factory.getSupportedProperties();
    }

    @Override
    public MetamodelImpl getMetamodel() {
        if (this._metaModel == null) {
            MetaDataRepository mdr = this.getConfiguration().getMetaDataRepositoryInstance();
            mdr.setValidate(8, true);
            mdr.setResolve(8, true);
            this._metaModel = new MetamodelImpl(mdr);
        }
        return this._metaModel;
    }

    @Override
    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this;
    }

    @Override
    public Object getIdentifier(Object entity) {
        return OpenJPAPersistenceUtil.getIdentifier(this, entity);
    }

    @Override
    public boolean isLoaded(Object entity) {
        return this.isLoaded(entity, null);
    }

    @Override
    public boolean isLoaded(Object entity, String attribute) {
        if (entity == null) {
            return false;
        }
        return OpenJPAPersistenceUtil.isManagedBy(this, entity) && OpenJPAPersistenceUtil.isLoaded(entity, attribute) == LoadState.LOADED;
    }

    private void validateCfNameProps(OpenJPAConfiguration conf, String cfName, String cf2Name) {
        if (StringUtils.isNotEmpty(cfName) || StringUtils.isNotEmpty(cf2Name)) {
            if (conf.getDataCache() != "false" && conf.getDataCache() != null) {
                throw new ArgumentException(_loc.get("invalid-cfname-prop", new Object[]{"openjpa.DataCache (L2 Cache)", cfName, cf2Name}), null, null, true);
            }
            if (conf.getQueryCache() != "false" && conf.getQueryCache() != null) {
                throw new ArgumentException(_loc.get("invalid-cfname-prop", new Object[]{"openjpa.QueryCache", cfName, cf2Name}), null, null, true);
            }
            Object syncMap = conf.toProperties(false).get("openjpa.jdbc.SynchronizeMappings");
            if (syncMap != null) {
                throw new ArgumentException(_loc.get("invalid-cfname-prop", new Object[]{"openjpa.jdbc.SynchronizeMappings", cfName, cf2Name}), null, null, true);
            }
        }
    }
}

