/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.NotSupportedException;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.kernel.AbstractJDBCSeq;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.SchemaTool;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.UserException;

public class TableJDBCSeq
extends AbstractJDBCSeq
implements Configurable {
    public static final String ACTION_DROP = "drop";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_GET = "get";
    public static final String ACTION_SET = "set";
    public static final String DEFAULT_TABLE = "OPENJPA_SEQUENCE_TABLE";
    private static final Localizer _loc = Localizer.forPackage(TableJDBCSeq.class);
    private transient JDBCConfiguration _conf = null;
    private transient Log _log = null;
    private int _alloc = 50;
    private int _intValue = 1;
    private final ConcurrentHashMap<ClassMapping, Status> _stat = new ConcurrentHashMap();
    private DBIdentifier _table = DBIdentifier.newTable("OPENJPA_SEQUENCE_TABLE");
    private DBIdentifier _seqColumnName = DBIdentifier.newColumn("SEQUENCE_VALUE");
    private DBIdentifier _pkColumnName = DBIdentifier.newColumn("ID");
    private DBIdentifier[] _uniqueColumnNames;
    private DBIdentifier _uniqueConstraintName = DBIdentifier.NULL;
    private Column _seqColumn = null;
    private Column _pkColumn = null;

    public String getTable() {
        return this._table.getName();
    }

    public void setTable(String name) {
        String[] names = Normalizer.splitName(name);
        this._table = DBIdentifier.newTable(Normalizer.joinNames(names));
    }

    public void setTableName(String name) {
        this.setTable(name);
    }

    public String getSequenceColumn() {
        return this._seqColumnName.getName();
    }

    public void setSequenceColumn(String sequenceColumn) {
        this._seqColumnName = DBIdentifier.newColumn(sequenceColumn);
    }

    public String getPrimaryKeyColumn() {
        return this._pkColumnName.getName();
    }

    public DBIdentifier getPrimaryKeyColumnIdentifier() {
        return this._pkColumnName;
    }

    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this._pkColumnName = DBIdentifier.newColumn(primaryKeyColumn);
    }

    public int getAllocate() {
        return this._alloc;
    }

    public void setAllocate(int alloc) {
        this._alloc = alloc;
    }

    public int getInitialValue() {
        return this._intValue;
    }

    public void setInitialValue(int intValue) {
        this._intValue = intValue;
    }

    public void setUniqueColumns(String columnNames) {
        this._uniqueColumnNames = StringUtils.isEmpty(columnNames) ? null : DBIdentifier.split(columnNames, DBIdentifier.DBIdentifierType.COLUMN, "|");
    }

    public String getUniqueColumns() {
        return Normalizer.joinNames(DBIdentifier.toStringArray(this._uniqueColumnNames), "|");
    }

    public void setIncrement(int inc) {
        this.setAllocate(inc);
    }

    @Override
    public JDBCConfiguration getConfiguration() {
        return this._conf;
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this._conf = (JDBCConfiguration)conf;
        this._log = this._conf.getLog("openjpa.Runtime");
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
        this.buildTable();
    }

    @Override
    public void addSchema(ClassMapping mapping, SchemaGroup group) {
        Schema[] schemas = group.getSchemas();
        for (int i = 0; i < schemas.length; ++i) {
            Unique[] uniques;
            Schema schema;
            QualifiedDBIdentifier path = QualifiedDBIdentifier.getPath(this._table);
            DBIdentifier schemaName = path.getSchemaName();
            if (DBIdentifier.isEmpty(schemaName)) {
                schemaName = Schemas.getNewTableSchemaIdentifier(this._conf);
            }
            if (DBIdentifier.isNull(schemaName)) {
                schemaName = schemas[i].getIdentifier();
            }
            if ((schema = group.getSchema(schemaName)) == null) {
                schema = group.addSchema(schemaName);
            }
            Table copy = schema.importTable(this._pkColumn.getTable());
            for (Unique u : uniques = this._pkColumn.getTable().getUniques()) {
                copy.importUnique(u);
            }
            this._pkColumn.resetTableIdentifier(QualifiedDBIdentifier.newPath(schemaName, this._pkColumn.getTableIdentifier()));
            this._conf.getDBDictionaryInstance().createIndexIfNecessary(schema, this._table, this._pkColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object nextInternal(JDBCStore store, ClassMapping mapping) throws Exception {
        Status stat = this.getStatus(mapping);
        if (stat == null) {
            throw new InvalidStateException(_loc.get("bad-seq-type", this.getClass(), mapping));
        }
        while (true) {
            Status status = stat;
            synchronized (status) {
                stat.seq = Math.max(stat.seq, 1L);
                if (stat.seq < stat.max) {
                    return stat.seq++;
                }
                this.allocateSequence(store, mapping, stat, this._alloc, true);
            }
        }
    }

    @Override
    protected Object currentInternal(JDBCStore store, ClassMapping mapping) throws Exception {
        if (this.current == null) {
            CurrentSequenceRunnable runnable = new CurrentSequenceRunnable(store, mapping);
            try {
                if (this.suspendInJTA()) {
                    this._conf.getManagedRuntimeInstance().doNonTransactionalWork(runnable);
                } else {
                    runnable.run();
                }
            }
            catch (RuntimeException re) {
                throw (Exception)(re.getCause() == null ? re : re.getCause());
            }
        }
        return super.currentInternal(store, mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void allocateInternal(int count, JDBCStore store, ClassMapping mapping) throws SQLException {
        Status stat = this.getStatus(mapping);
        if (stat == null) {
            return;
        }
        while (true) {
            int available;
            Status status = stat;
            synchronized (status) {
                available = (int)(stat.max - stat.seq);
                if (available >= count) {
                    return;
                }
            }
            this.allocateSequence(store, mapping, stat, count - available, false);
        }
    }

    protected Status getStatus(ClassMapping mapping) {
        Status tStatus;
        Status status = this._stat.get(mapping);
        if (status == null && (tStatus = this._stat.putIfAbsent(mapping, status = new Status())) != null) {
            return tStatus;
        }
        return status;
    }

    protected Column addPrimaryKeyColumn(Table table) {
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        Column pkColumn = table.addColumn(dict.getValidColumnName(this.getPrimaryKeyColumnIdentifier(), table));
        pkColumn.setType(dict.getPreferredType(-6));
        pkColumn.setJavaType(5);
        return pkColumn;
    }

    protected Object getPrimaryKey(ClassMapping mapping) {
        return 0;
    }

    private void buildTable() {
        DBIdentifier tableName = DBIdentifier.NULL;
        DBIdentifier schemaName = DBIdentifier.NULL;
        QualifiedDBIdentifier path = QualifiedDBIdentifier.getPath(this._table);
        if (!DBIdentifier.isEmpty(path.getSchemaName())) {
            schemaName = path.getSchemaName();
            tableName = path.getUnqualifiedName();
        } else {
            tableName = this._table;
        }
        if (DBIdentifier.isEmpty(schemaName)) {
            schemaName = Schemas.getNewTableSchemaIdentifier(this._conf);
        }
        SchemaGroup group = new SchemaGroup();
        Schema schema = group.addSchema(schemaName);
        Table table = schema.addTable(tableName);
        this._pkColumn = this.addPrimaryKeyColumn(table);
        PrimaryKey pk = table.addPrimaryKey();
        pk.addColumn(this._pkColumn);
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        this._seqColumn = table.addColumn(dict.getValidColumnName(this._seqColumnName, table));
        this._seqColumn.setType(dict.getPreferredType(-5));
        this._seqColumn.setJavaType(6);
        if (this._uniqueColumnNames != null) {
            DBIdentifier uniqueName = this._uniqueConstraintName;
            if (DBIdentifier.isEmpty(uniqueName)) {
                uniqueName = dict.getValidUniqueName(DBIdentifier.newConstraint("UNQ"), table);
            }
            Unique u = table.addUnique(uniqueName);
            for (DBIdentifier columnName : this._uniqueColumnNames) {
                if (!table.containsColumn(columnName, this._conf.getDBDictionaryInstance())) {
                    throw new UserException(_loc.get("unique-missing-column", columnName, table.getIdentifier(), table.getColumnNames()));
                }
                Column col = table.getColumn(columnName);
                u.addColumn(col);
            }
        }
    }

    private void allocateSequence(JDBCStore store, ClassMapping mapping, Status stat, int alloc, boolean updateStatSeq) throws SQLException {
        block6: {
            AllocateSequenceRunnable runnable = new AllocateSequenceRunnable(store, mapping, stat, alloc, updateStatSeq);
            try {
                if (this.suspendInJTA()) {
                    try {
                        this._conf.getManagedRuntimeInstance().doNonTransactionalWork(runnable);
                        break block6;
                    }
                    catch (NotSupportedException nse) {
                        SQLException sqlEx = new SQLException(nse.getLocalizedMessage());
                        sqlEx.initCause(nse);
                        throw sqlEx;
                    }
                }
                runnable.run();
            }
            catch (RuntimeException re) {
                Throwable e = re.getCause();
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw re;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSequence(ClassMapping mapping, Connection conn) throws SQLException {
        Object pk;
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("insert-seq"));
        }
        if ((pk = this.getPrimaryKey(mapping)) == null) {
            throw new InvalidStateException(_loc.get("bad-seq-type", this.getClass(), mapping));
        }
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        DBIdentifier tableName = this.resolveTableIdentifier(mapping, this._pkColumn.getTable());
        SQLBuffer insert = new SQLBuffer(dict).append("INSERT INTO ").append(tableName).append(" (").append(this._pkColumn).append(", ").append(this._seqColumn).append(") VALUES (").appendValue(pk, this._pkColumn).append(", ").appendValue(this._intValue, this._seqColumn).append(")");
        boolean wasAuto = conn.getAutoCommit();
        if (!wasAuto && !this.suspendInJTA()) {
            conn.setAutoCommit(true);
        }
        PreparedStatement stmnt = null;
        try {
            stmnt = this.prepareStatement(conn, insert);
            dict.setTimeouts(stmnt, this._conf, true);
            this.executeUpdate(this._conf, conn, stmnt, insert, 1);
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
            if (!wasAuto && !this.suspendInJTA()) {
                conn.setAutoCommit(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getSequence(ClassMapping mapping, Connection conn) throws SQLException {
        Object pk;
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("get-seq"));
        }
        if ((pk = this.getPrimaryKey(mapping)) == null) {
            return -1L;
        }
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        SQLBuffer sel = new SQLBuffer(dict).append(this._seqColumn);
        SQLBuffer where = new SQLBuffer(dict).append(this._pkColumn).append(" = ").appendValue(pk, this._pkColumn);
        DBIdentifier tableName = this.resolveTableIdentifier(mapping, this._seqColumn.getTable());
        SQLBuffer tables = new SQLBuffer(dict).append(tableName);
        SQLBuffer select = dict.toSelect(sel, null, tables, where, null, null, null, false, dict.supportsSelectForUpdate, 0L, Long.MAX_VALUE, false, true);
        PreparedStatement stmnt = null;
        ResultSet rs = null;
        try {
            stmnt = this.prepareStatement(conn, select);
            dict.setTimeouts(stmnt, this._conf, false);
            rs = this.executeQuery(this._conf, conn, stmnt, select);
            long l = this.getSequence(rs, dict);
            return l;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setSequence(ClassMapping mapping, Status stat, int inc, boolean updateStatSeq, Connection conn) throws SQLException {
        Object pk;
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("update-seq"));
        }
        if ((pk = this.getPrimaryKey(mapping)) == null) {
            throw new InvalidStateException(_loc.get("bad-seq-type", this.getClass(), mapping));
        }
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        SQLBuffer where = new SQLBuffer(dict).append(this._pkColumn).append(" = ").appendValue(pk, this._pkColumn);
        long cur = 0L;
        int updates = 0;
        while (updates == 0) {
            Statement stmnt = null;
            ResultSet rs = null;
            try {
                cur = this.getSequence(mapping, conn);
                if (cur == -1L) {
                    boolean bl = false;
                    return bl;
                }
                SQLBuffer upd = new SQLBuffer(dict);
                DBIdentifier tableName = this.resolveTableIdentifier(mapping, this._seqColumn.getTable());
                upd.append("UPDATE ").append(tableName).append(" SET ").append(this._seqColumn).append(" = ").appendValue(cur + (long)inc, this._seqColumn).append(" WHERE ").append(where).append(" AND ").append(this._seqColumn).append(" = ").appendValue(cur, this._seqColumn);
                stmnt = this.prepareStatement(conn, upd);
                dict.setTimeouts((PreparedStatement)stmnt, this._conf, true);
                updates = this.executeUpdate(this._conf, conn, (PreparedStatement)stmnt, upd, 0);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException se) {}
                }
                if (stmnt == null) continue;
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
        }
        Status status = stat;
        synchronized (status) {
            if (updateStatSeq && stat.seq < cur) {
                stat.seq = cur;
            }
            if (stat.max < cur + (long)inc) {
                stat.max = cur + (long)inc;
            }
        }
        return true;
    }

    public String resolveTableName(ClassMapping mapping, Table table) {
        return this.resolveTableIdentifier(mapping, table).getName();
    }

    public DBIdentifier resolveTableIdentifier(ClassMapping mapping, Table table) {
        DBIdentifier sName = mapping.getTable().getSchemaIdentifier();
        DBIdentifier tableName = DBIdentifier.NULL;
        tableName = DBIdentifier.isNull(sName) ? table.getFullIdentifier() : (!DBIdentifier.isNull(table.getSchemaIdentifier()) ? table.getFullIdentifier() : QualifiedDBIdentifier.newPath(sName, table.getIdentifier()));
        return tableName;
    }

    public void refreshTable() throws SQLException {
        if (this._log.isInfoEnabled()) {
            this._log.info(_loc.get("make-seq-table"));
        }
        SchemaTool tool = new SchemaTool(this._conf);
        tool.setIgnoreErrors(true);
        tool.createTable(this._pkColumn.getTable());
    }

    public void dropTable() throws SQLException {
        if (this._log.isInfoEnabled()) {
            this._log.info(_loc.get("drop-seq-table"));
        }
        SchemaTool tool = new SchemaTool(this._conf);
        tool.setIgnoreErrors(true);
        tool.dropTable(this._pkColumn.getTable());
    }

    public static void main(String[] args) throws Exception {
        Options opts = new Options();
        final String[] arguments = opts.setFromCmdLine(args);
        boolean ret = Configurations.runAgainstAllAnchors(opts, new Configurations.Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(Options opts) throws Exception {
                JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
                try {
                    boolean bl = TableJDBCSeq.run((JDBCConfiguration)conf, arguments, opts);
                    return bl;
                }
                finally {
                    conf.close();
                }
            }
        });
        if (!ret) {
            System.out.println(_loc.get("seq-usage"));
        }
    }

    public static boolean run(JDBCConfiguration conf, String[] args, Options opts) throws Exception {
        String action = opts.removeProperty("action", "a", null);
        Configurations.populateConfiguration(conf, opts);
        return TableJDBCSeq.run(conf, args, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(JDBCConfiguration conf, String[] args, String action) throws Exception {
        if (args.length > 1 || args.length != 0 && !ACTION_SET.equals(action)) {
            return false;
        }
        TableJDBCSeq seq = new TableJDBCSeq();
        String props = Configurations.getProperties(conf.getSequence());
        Configurations.configureInstance((Object)seq, (Configuration)conf, props);
        if (ACTION_DROP.equals(action)) {
            seq.dropTable();
        } else if (ACTION_ADD.equals(action)) {
            seq.refreshTable();
        } else if (ACTION_GET.equals(action) || ACTION_SET.equals(action)) {
            Connection conn = conf.getDataSource2(null).getConnection();
            try {
                long cur = seq.getSequence(null, conn);
                if (ACTION_GET.equals(action)) {
                    System.out.println(cur);
                }
                long set = args.length > 0 ? Long.parseLong(args[0]) : cur + (long)seq.getAllocate();
                if (set < cur) {
                    set = cur;
                } else {
                    Status stat = seq.getStatus(null);
                    seq.setSequence(null, stat, (int)(set - cur), true, conn);
                    set = stat.seq;
                }
                System.err.println(set);
            }
            catch (NumberFormatException nfe) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
        } else {
            return false;
        }
        return true;
    }

    protected PreparedStatement prepareStatement(Connection conn, SQLBuffer buf) throws SQLException {
        return buf.prepareStatement(conn);
    }

    protected int executeUpdate(JDBCConfiguration conf, Connection conn, PreparedStatement stmnt, SQLBuffer buf, int opcode) throws SQLException {
        return stmnt.executeUpdate();
    }

    protected ResultSet executeQuery(JDBCConfiguration conf, Connection conn, PreparedStatement stmnt, SQLBuffer buf) throws SQLException {
        return stmnt.executeQuery();
    }

    protected long getSequence(ResultSet rs, DBDictionary dict) throws SQLException {
        if (rs == null || !rs.next()) {
            return -1L;
        }
        return dict.getLong(rs, 1);
    }

    public void setUniqueConstraintName(String uniqueConstraintName) {
        this._uniqueConstraintName = DBIdentifier.newConstraint(uniqueConstraintName);
    }

    public void setUniqueConstraintName(DBIdentifier uniqueConstraintName) {
        this._uniqueConstraintName = uniqueConstraintName;
    }

    public String getUniqueConstraintName() {
        return this._uniqueConstraintName.getName();
    }

    public DBIdentifier getUniqueConstraintIdentifier() {
        return this._uniqueConstraintName;
    }

    protected class CurrentSequenceRunnable
    implements Runnable {
        private JDBCStore _store;
        private ClassMapping _mapping;

        CurrentSequenceRunnable(JDBCStore store, ClassMapping mapping) {
            this._store = store;
            this._mapping = mapping;
        }

        @Override
        public void run() throws RuntimeException {
            Connection conn = null;
            try {
                conn = TableJDBCSeq.this.getConnection(this._store);
                long cur = TableJDBCSeq.this.getSequence(this._mapping, conn);
                if (cur != -1L) {
                    TableJDBCSeq.this.current = cur;
                }
            }
            catch (SQLException sqle) {
                RuntimeException re = new RuntimeException(sqle.getMessage());
                re.initCause(sqle);
                throw re;
            }
            finally {
                if (conn != null) {
                    TableJDBCSeq.this.closeConnection(conn);
                }
            }
        }
    }

    protected class AllocateSequenceRunnable
    implements Runnable {
        JDBCStore store = null;
        ClassMapping mapping = null;
        Status stat = null;
        int alloc;
        boolean updateStatSeq;

        AllocateSequenceRunnable(JDBCStore store, ClassMapping mapping, Status stat, int alloc, boolean updateStatSeq) {
            this.store = store;
            this.mapping = mapping;
            this.stat = stat;
            this.alloc = alloc;
            this.updateStatSeq = updateStatSeq;
        }

        @Override
        public void run() throws RuntimeException {
            block6: {
                Connection conn = null;
                SQLException err = null;
                try {
                    block7: {
                        conn = TableJDBCSeq.this.getConnection(this.store);
                        boolean sequenceSet = TableJDBCSeq.this.setSequence(this.mapping, this.stat, this.alloc, this.updateStatSeq, conn);
                        TableJDBCSeq.this.closeConnection(conn);
                        if (sequenceSet) break block6;
                        conn = TableJDBCSeq.this._conf.getDataSource2(this.store.getContext()).getConnection();
                        try {
                            TableJDBCSeq.this.insertSequence(this.mapping, conn);
                        }
                        catch (SQLException e) {
                            if (!TableJDBCSeq.this._log.isTraceEnabled()) break block7;
                            TableJDBCSeq.this._log.trace("Caught an exception while trying to insert sequence. Will try to reselect the seqence. ", e);
                        }
                    }
                    conn.close();
                    conn = TableJDBCSeq.this.getConnection(this.store);
                    if (!TableJDBCSeq.this.setSequence(this.mapping, this.stat, this.alloc, this.updateStatSeq, conn)) {
                        throw err != null ? err : new SQLException(_loc.get("no-seq-row", this.mapping, TableJDBCSeq.this._table).getMessage());
                    }
                    TableJDBCSeq.this.closeConnection(conn);
                }
                catch (SQLException e) {
                    if (conn != null) {
                        TableJDBCSeq.this.closeConnection(conn);
                    }
                    RuntimeException re = new RuntimeException(e.getMessage());
                    re.initCause(e);
                    throw re;
                }
            }
        }
    }

    protected static class Status
    implements Serializable {
        public long seq = 1L;
        public long max = 0L;

        protected Status() {
        }
    }
}

