/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Exp;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;

class ContainsExpression
extends Exp {
    private final Val _val1;
    private final Val _val2;

    public ContainsExpression(Val val1, Val val2) {
        this._val1 = val1;
        this._val2 = val2;
    }

    @Override
    protected boolean eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        Object obj = this._val1.eval(candidate, orig, ctx, params);
        Collection coll = this.getCollection(obj);
        return coll != null && !coll.isEmpty() && coll.contains(this._val2.eval(candidate, orig, ctx, params));
    }

    @Override
    protected boolean eval(Collection candidates, StoreContext ctx, Object[] params) {
        Collection coll = this._val1.eval(candidates, null, ctx, params);
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        if ((coll = this.getCollection(coll.iterator().next())) == null || coll.isEmpty()) {
            return false;
        }
        Collection coll2 = this._val2.eval(candidates, null, ctx, params);
        if (coll2 == null || coll2.isEmpty()) {
            return false;
        }
        return coll.contains(coll2.iterator().next());
    }

    protected Collection getCollection(Object obj) {
        return obj instanceof Collection ? (Set<Object>)obj : Collections.singleton(obj);
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val1.acceptVisit(visitor);
        this._val2.acceptVisit(visitor);
        visitor.exit(this);
    }
}

