/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;

public class TomcatEmbedder {
    private static final String OPENEJB_LOADER_PREFIX = "openejb-loader";
    private static final String TOMEE_WAR_NAME = "tomee.war";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void embed(Properties properties, ClassLoader catalinaCl) {
        if (catalinaCl == null) {
            throw new NullPointerException("catalinaCl is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        if (!properties.containsKey(TOMEE_WAR_NAME)) {
            throw new IllegalArgumentException("properties must contain the tomee.war property");
        }
        File openejbWar = new File(properties.getProperty(TOMEE_WAR_NAME));
        if (!openejbWar.isDirectory()) {
            throw new IllegalArgumentException("tomee.war is not a directory: " + openejbWar);
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(catalinaCl);
        try {
            Class<?> webappClClass = catalinaCl.loadClass("org.apache.catalina.loader.WebappClassLoader");
            ClassLoader childCl = (ClassLoader)webappClClass.getConstructor(ClassLoader.class).newInstance(catalinaCl);
            File thisJar = TomcatEmbedder.getThisJar();
            String thisJarUrl = thisJar.toURI().toString();
            webappClClass.getMethod("addRepository", String.class).invoke((Object)childCl, thisJarUrl);
            File jarFile = TomcatEmbedder.findOpenEJBJar(openejbWar, OPENEJB_LOADER_PREFIX);
            String openejbLoaderUrl = jarFile.toURI().toString();
            webappClClass.getMethod("addRepository", String.class).invoke((Object)childCl, openejbLoaderUrl);
            webappClClass.getMethod("start", new Class[0]).invoke((Object)childCl, new Object[0]);
            Class<?> tomcatUtilClass = childCl.loadClass("org.apache.tomee.loader.TomcatHook");
            Method hookMethod = tomcatUtilClass.getDeclaredMethod("hook", Properties.class);
            hookMethod.setAccessible(true);
            hookMethod.invoke(null, properties);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    private static File getThisJar() {
        return TomcatEmbedder.jarLocation(TomcatEmbedder.class);
    }

    private static File jarLocation(Class<?> clazz) {
        try {
            String path;
            String classFileName = clazz.getName().replace(".", "/") + ".class";
            URL classURL = clazz.getClassLoader().getResource(classFileName);
            URI uri = null;
            String url = classURL.toExternalForm();
            if (url.contains("+")) {
                url = url.replaceAll("\\+", "%2B");
            }
            if (url.contains(" ")) {
                url = url.replaceAll(" ", "%20");
            }
            if ((uri = new URI(url)).getPath() == null) {
                uri = new URI(uri.getRawSchemeSpecificPart());
            }
            path = (path = uri.getPath()).contains("!") ? path.substring(0, path.indexOf(33)) : path.substring(0, path.length() - classFileName.length());
            path = path.replaceAll("\\+", "%2B");
            return new File(URLDecoder.decode(path));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static File findOpenEJBJar(File tomeeWar, String namePrefix) {
        File openEJBLibDir = new File(tomeeWar, "lib");
        if (openEJBLibDir == null) {
            return null;
        }
        File openejbLoaderJar = null;
        File[] files = openEJBLibDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().startsWith(namePrefix + "-") || !file.getName().endsWith(".jar")) continue;
                return file;
            }
        }
        return openejbLoaderJar;
    }
}

