/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import javax.validation.ValidationException;
import org.apache.geronimo.osgi.locator.ProviderLocator;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Exceptions;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.NetworkUtil;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;

public final class EmbeddedTomEEContainer
extends EJBContainer {
    public static final String TOMEE_EJBCONTAINER_HTTP_PORT = "tomee.ejbcontainer.http.port";
    private static EmbeddedTomEEContainer tomEEContainer;
    private static final List<String> CONTAINER_NAMES;
    private Container container = new Container();
    private Collection<String> deployedIds = new ArrayList<String>();

    private EmbeddedTomEEContainer() {
    }

    public Container getDelegate() {
        return this.container;
    }

    public void close() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (String id : this.deployedIds) {
            if (EmbeddedTomEEContainer.tomEEContainer.container.getAppContexts(id) == null) continue;
            try {
                EmbeddedTomEEContainer.tomEEContainer.container.undeploy(id);
            }
            catch (Exception ex) {
                Logger.getInstance((LogCategory)LogCategory.OPENEJB, EmbeddedTomEEContainer.class).error(ex.getMessage(), (Throwable)ex);
                errors.add(ex);
            }
        }
        this.deployedIds.clear();
        try {
            EmbeddedTomEEContainer.tomEEContainer.container.stop();
        }
        catch (Exception ex) {
            errors.add(ex);
            Logger.getInstance((LogCategory)LogCategory.OPENEJB, EmbeddedTomEEContainer.class).error(ex.getMessage(), (Throwable)ex);
        }
        tomEEContainer = null;
        if (!errors.isEmpty()) {
            throw Exceptions.newEJBException((Throwable)new TomEERuntimeException(((Object)errors).toString()));
        }
    }

    public Context getContext() {
        return EmbeddedTomEEContainer.tomEEContainer.container.getJndiContext();
    }

    static {
        CONTAINER_NAMES = Arrays.asList(EmbeddedTomEEContainer.class.getName(), "tomee-embedded", "embedded-tomee");
    }

    public static class EmbeddedTomEEContainerProvider
    implements EJBContainerProvider {
        public EJBContainer createEJBContainer(Map<?, ?> properties) {
            Object provider = properties.get("javax.ejb.embeddable.provider");
            int ejbContainerProviders = 1;
            try {
                ejbContainerProviders = ProviderLocator.getServices((String)EJBContainerProvider.class.getName(), EJBContainer.class, (ClassLoader)Thread.currentThread().getContextClassLoader()).size();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (provider == null && ejbContainerProviders > 1 || !EmbeddedTomEEContainer.class.equals(provider) && !CONTAINER_NAMES.contains(String.valueOf(provider))) {
                return null;
            }
            if (tomEEContainer != null) {
                return tomEEContainer;
            }
            String appId = (String)properties.get("javax.ejb.embeddable.appName");
            Object modules = properties.get("javax.ejb.embeddable.modules");
            tomEEContainer = new EmbeddedTomEEContainer();
            Configuration configuration = new Configuration();
            if (properties.containsKey(EmbeddedTomEEContainer.TOMEE_EJBCONTAINER_HTTP_PORT)) {
                int port;
                Object portValue = properties.get(EmbeddedTomEEContainer.TOMEE_EJBCONTAINER_HTTP_PORT);
                if (portValue instanceof Integer) {
                    port = (Integer)portValue;
                } else if (portValue instanceof String) {
                    port = Integer.parseInt((String)portValue);
                } else {
                    throw new TomEERuntimeException("port value should be an integer or a string");
                }
                if (port <= 0) {
                    port = NetworkUtil.getNextAvailablePort();
                }
                configuration.setHttpPort(port);
            }
            System.setProperty(EmbeddedTomEEContainer.TOMEE_EJBCONTAINER_HTTP_PORT, Integer.toString(configuration.getHttpPort()));
            tomEEContainer.container.setup(configuration);
            try {
                tomEEContainer.container.start();
                if (modules instanceof File) {
                    tomEEContainer.deployedIds.add(tomEEContainer.container.deploy(appId, (File)modules, appId != null).getId());
                } else if (modules instanceof String) {
                    tomEEContainer.deployedIds.add(tomEEContainer.container.deploy(appId, new File((String)modules), appId != null).getId());
                } else if (modules instanceof String[]) {
                    for (String path : (String[])modules) {
                        tomEEContainer.deployedIds.add(tomEEContainer.container.deploy(appId, new File(path), appId != null).getId());
                    }
                } else if (modules instanceof File[]) {
                    for (File file : (File[])modules) {
                        tomEEContainer.deployedIds.add(tomEEContainer.container.deploy(appId, file, appId != null).getId());
                    }
                } else {
                    SystemInstance.get().getProperties().putAll(properties);
                    ArrayList files = tomEEContainer.container.getConfigurationFactory().getModulesFromClassPath(null, Thread.currentThread().getContextClassLoader());
                    if (files.size() == 0) {
                        try {
                            tomEEContainer.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        tomEEContainer = null;
                        throw Exceptions.newNoModulesFoundException();
                    }
                    for (File file : files) {
                        tomEEContainer.deployedIds.add(tomEEContainer.container.deploy(appId, file, appId != null).getId());
                    }
                }
                return tomEEContainer;
            }
            catch (OpenEJBException e) {
                tomEEContainer.close();
                throw new EJBException((Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                tomEEContainer.close();
                throw new EJBException((Exception)e);
            }
            catch (ValidationException ve) {
                if (tomEEContainer != null) {
                    tomEEContainer.close();
                }
                throw ve;
            }
            catch (Exception e) {
                if (tomEEContainer != null) {
                    tomEEContainer.close();
                }
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                throw new TomEERuntimeException("initialization exception", (Throwable)e);
            }
        }
    }
}

