/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import org.apache.openjpa.jdbc.kernel.exps.Const;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.Raw;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.Literal;

public class Lit
extends Const
implements Literal {
    private Object _val;
    private int _ptype;
    private boolean _isRaw;
    private Object _rawVal;

    public Lit(Object val, int ptype) {
        this._val = val;
        this._ptype = ptype;
        if (this._ptype == 8 || this._ptype == 9 || this._ptype == 10) {
            this._isRaw = true;
        }
    }

    @Override
    public Class getType() {
        if (this._isRaw && this._rawVal != null) {
            return Raw.class;
        }
        return this._val == null ? Object.class : this._val.getClass();
    }

    @Override
    public void setImplicitType(Class type) {
        this._val = Filters.convert(this._val, type);
    }

    @Override
    public int getParseType() {
        return this._ptype;
    }

    @Override
    public Object getValue() {
        return this._val;
    }

    @Override
    public void setValue(Object val) {
        this._val = val;
    }

    @Override
    public Object getValue(Object[] params) {
        return this.getValue();
    }

    public boolean isRaw() {
        return this._isRaw;
    }

    public void setRaw(boolean isRaw) {
        this._isRaw = isRaw;
    }

    public Object getRawValue() {
        return this._rawVal;
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        return new LitExpState();
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        super.calculateValue(sel, ctx, state, other, otherState);
        LitExpState lstate = (LitExpState)state;
        if (other != null) {
            lstate.sqlValue = other.toDataStoreValue(sel, ctx, otherState, this._val);
            lstate.otherLength = other.length(sel, ctx, otherState);
        } else {
            lstate.sqlValue = this._val;
        }
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        LitExpState lstate = (LitExpState)state;
        if (lstate.otherLength > 1) {
            sql2.appendValue(((Object[])lstate.sqlValue)[index], lstate.getColumn(index));
        } else if (this._isRaw) {
            int parseType = this.getParseType();
            if (parseType == 6) {
                StringBuilder value = new StringBuilder();
                boolean isOrdinal = false;
                if (lstate.sqlValue instanceof Integer) {
                    isOrdinal = true;
                }
                if (!isOrdinal) {
                    value.append("'");
                }
                value.append(lstate.sqlValue);
                if (!isOrdinal) {
                    value.append("'");
                }
                this._rawVal = lstate.sqlValue = new Raw(value.toString());
            } else {
                this._rawVal = parseType == 8 || parseType == 9 || parseType == 10 ? (lstate.sqlValue = new Raw(this._val.toString())) : (lstate.sqlValue = new Raw(this._val instanceof String ? "'" + this._val + "'" : this._val.toString()));
            }
        }
        Object useLiteral = ctx.fetch.getHint("openjpa.hint.UseLiteralInSQL");
        boolean useParamToken = useLiteral != null ? !((Boolean)useLiteral).booleanValue() : true;
        sql2.appendValue(lstate.sqlValue, lstate.getColumn(index), null, useParamToken);
    }

    private static class LitExpState
    extends Const.ConstExpState {
        public Object sqlValue;
        public int otherLength;

        private LitExpState() {
        }
    }
}

