/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.loader.Options;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.discovery.MultipointServer;
import org.apache.openejb.server.discovery.Tracker;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class MultipointDiscoveryAgent
implements DiscoveryAgent,
ServerService,
SelfManaging {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("discovery"), MultipointDiscoveryAgent.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private String host = "127.0.0.1";
    private int port = 4212;
    private String initialServers = "";
    private long heartRate = 500L;
    private Tracker tracker;
    private MultipointServer multipointServer;

    public void init(Properties props) {
        Options options = new Options(props);
        this.host = props.getProperty("bind", this.host);
        this.port = options.get("port", this.port);
        this.initialServers = options.get("initialServers", this.initialServers);
        this.heartRate = options.get("heart_rate", this.heartRate);
        Tracker.Builder builder = new Tracker.Builder();
        builder.setGroup(props.getProperty("group", builder.getGroup()));
        builder.setMaxMissedHeartbeats(options.get("max_missed_heartbeats", builder.getMaxMissedHeartbeats()));
        builder.setMaxReconnectDelay(options.get("max_reconnect_delay", builder.getMaxReconnectDelay()));
        builder.setReconnectDelay(options.get("reconnect_delay", builder.getReconnectDelay()));
        builder.setExponentialBackoff(options.get("exponential_backoff", builder.getExponentialBackoff()));
        builder.setMaxReconnectAttempts(options.get("max_reconnect_attempts", builder.getMaxReconnectAttempts()));
        this.tracker = builder.build();
    }

    public String getIP() {
        return this.host;
    }

    public String getName() {
        return "multipoint";
    }

    public int getPort() {
        return this.port;
    }

    public String getInitialServers() {
        return this.initialServers;
    }

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.tracker.setDiscoveryListener(listener);
    }

    public void registerService(URI serviceUri) throws IOException {
        this.tracker.registerService(serviceUri);
    }

    public void unregisterService(URI serviceUri) throws IOException {
        this.tracker.unregisterService(serviceUri);
    }

    public void reportFailed(URI serviceUri) {
        this.tracker.reportFailed(serviceUri);
    }

    public static void main(String[] args) throws Exception {
    }

    public void start() throws ServiceException {
        try {
            if (this.running.compareAndSet(false, true)) {
                this.multipointServer = new MultipointServer(this.host, this.port, this.tracker).start();
                this.port = this.multipointServer.getPort();
                StringTokenizer st = new StringTokenizer(this.initialServers, ",");
                while (st.hasMoreTokens()) {
                    this.multipointServer.connect(URI.create("conn://" + st.nextToken().trim()));
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException(this.port + "", (Throwable)e);
        }
    }

    public void stop() throws ServiceException {
        if (this.running.compareAndSet(true, false)) {
            this.multipointServer.stop();
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

