/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.LocationResolver;
import org.apache.openejb.loader.SystemInstance;

public class ProvisioningUtil {
    public static final String OPENEJB_DEPLOYER_CACHE_FOLDER = "openejb.deployer.cache.folder";
    public static final String HTTP_PREFIX = "http";
    private static final int CONNECT_TIMEOUT = 10000;

    private ProvisioningUtil() {
    }

    public static String cache() {
        return System.getProperty(OPENEJB_DEPLOYER_CACHE_FOLDER, "temp");
    }

    public static File cacheFile(String path) {
        return new File(SystemInstance.get().getBase().getDirectory(), ProvisioningUtil.cache() + File.separator + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyTryingProxies(URI source, File destination) throws Exception {
        InputStream is = ProvisioningUtil.inputStreamTryingProxies(source);
        if (is == null) {
            return null;
        }
        try {
            IO.copy(is, destination);
        }
        finally {
            IO.close(is);
        }
        return destination.getAbsolutePath();
    }

    public static InputStream inputStreamTryingProxies(URI source) throws Exception {
        URL url = source.toURL();
        for (Proxy proxy : ProxySelector.getDefault().select(source)) {
            try {
                URLConnection urlConnection = url.openConnection(proxy);
                urlConnection.setConnectTimeout(10000);
                return new BufferedInputStream(urlConnection.getInputStream());
            }
            catch (IOException e) {
            }
        }
        return null;
    }

    public static String lastPart(String location) {
        int idx = location.lastIndexOf(47);
        if (idx <= 0) {
            return location;
        }
        return location.substring(idx + 1, location.length());
    }

    public static String realLocation(String rawLocation) {
        if (rawLocation.startsWith(HTTP_PREFIX)) {
            File file = ProvisioningUtil.cacheFile(ProvisioningUtil.lastPart(rawLocation));
            String path = null;
            try {
                path = ProvisioningUtil.copyTryingProxies(new URI(rawLocation), file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (path != null) {
                return path;
            }
        }
        try {
            Class<?> clazz = ProvisioningUtil.class.getClassLoader().loadClass("org.apache.openejb.resolver.Resolver");
            LocationResolver instance = (LocationResolver)clazz.newInstance();
            return instance.resolve(rawLocation);
        }
        catch (Exception e) {
            return rawLocation;
        }
    }
}

