/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionContext;
import org.apache.openejb.client.ArrayEnumeration;
import org.apache.openejb.server.httpd.HttpSession;

public class HttpSessionImpl
implements HttpSession {
    private String sessionId = UUID.randomUUID().toString();
    private Map<String, Object> attributes = new HashMap<String, Object>();

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeValue(String s) {
        for (String key : this.attributes.keySet()) {
            if (!this.attributes.get(key).equals(s)) continue;
            this.attributes.remove(key);
        }
    }

    public void invalidate() {
        this.attributes.clear();
    }

    public boolean isNew() {
        return false;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getValue(String s) {
        return this.attributes.get(s);
    }

    public Enumeration<String> getAttributeNames() {
        return new ArrayEnumeration(new ArrayList<String>(this.attributes.keySet()));
    }

    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void putValue(String s, Object o) {
        this.setAttribute(s, o);
    }

    public long getCreationTime() {
        return -1L;
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return -1L;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public void setMaxInactiveInterval(int i) {
    }

    public int getMaxInactiveInterval() {
        return -1;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }
}

