/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.RuntimeDelegate;

public class NewCookie
extends Cookie {
    public static final int DEFAULT_MAX_AGE = -1;
    private final String comment;
    private final int maxAge;
    private final boolean isSecure;
    private static final RuntimeDelegate.HeaderDelegate<NewCookie> headerDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(NewCookie.class);

    public NewCookie(String name, String value) {
        this(name, value, null, null, null, -1, false);
    }

    public NewCookie(String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure) {
        this(name, value, path, domain, 1, comment, maxAge, isSecure);
    }

    public NewCookie(String name, String value, String path, String domain, int version, String comment, int maxAge, boolean isSecure) {
        super(name, value, path, domain, version);
        this.comment = comment;
        this.maxAge = maxAge;
        this.isSecure = isSecure;
    }

    public NewCookie(Cookie cookie) {
        this(cookie, null, -1, false);
    }

    public NewCookie(Cookie cookie, String comment, int maxAge, boolean isSecure) {
        super(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion());
        this.comment = comment;
        this.maxAge = maxAge;
        this.isSecure = isSecure;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewCookie other = (NewCookie)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isSecure != other.isSecure) {
            return false;
        }
        if (this.maxAge != other.maxAge) {
            return false;
        }
        String value = this.getValue();
        if (value == null ? other.getValue() != null : !value.equals(other.getValue())) {
            return false;
        }
        String path = this.getPath();
        if (path == null ? other.getPath() != null : !path.equals(other.getPath())) {
            return false;
        }
        String domain = this.getDomain();
        if (domain == null ? other.getDomain() != null : !domain.equals(other.getDomain())) {
            return false;
        }
        return !(this.comment == null ? other.comment != null : !this.comment.equals(other.comment));
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + this.maxAge;
        result = 31 * result + (this.isSecure ? 1 : 0);
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public Cookie toCookie() {
        return new Cookie(this.getName(), this.getValue(), this.getPath(), this.getDomain(), this.getVersion());
    }

    public String toString() {
        return headerDelegate.toString(this);
    }

    public static NewCookie valueOf(String value) {
        return headerDelegate.fromString(value);
    }
}

