/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package javax.servlet;

/**
 * @version $Rev: 788194 $ $Date: 2009-06-24 18:05:48 -0400 (Wed, 24 Jun 2009) $
 * @since 3.0
 */
public interface SessionCookieConfig {

    String getComment();

    String getDomain();

    /**
     *
     * @return max age in seconds for this session cookie
     */
    int getMaxAge();

    String getName();

    String getPath();

    boolean isHttpOnly();

    boolean isSecure();

    void setComment(String comment);

    void setDomain(String domain);

    void setHttpOnly(boolean httpOnly);

    void setMaxAge(int maxAge);

    void setName(String name);

    void setPath(String path);

    void setSecure(boolean secure);
    
}
