/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.openejb.AppContext;
import org.apache.openejb.arquillian.common.enrichment.OpenEJBEnricher;
import org.apache.openejb.arquillian.common.mockito.MockitoEnricher;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.inject.OWBInjector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.TestEnricher;

public class OpenEJBInjectionEnricher
implements TestEnricher {
    @Inject
    private Instance<AppContext> appContext;
    @Inject
    private Instance<TestClass> testClass;

    public void enrich(Object testInstance) {
        if (!SystemInstance.isInitialized()) {
            return;
        }
        new MockitoEnricher().enrich(testInstance);
        AppContext context = (AppContext)this.appContext.get();
        if (context != null) {
            OpenEJBEnricher.enrich((Object)testInstance, (AppContext)context);
        } else {
            List appContexts = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContexts();
            Class<?> clazz = testInstance.getClass();
            for (AppContext appContext : appContexts) {
                try {
                    BeanManagerImpl bm = appContext.getWebBeansContext().getBeanManagerImpl();
                    AnnotatedType at = bm.createAnnotatedType(clazz);
                    bm.createInjectionTarget(at);
                    CreationalContext cc = bm.createCreationalContext(null);
                    OWBInjector.inject((BeanManager)bm, (Object)testInstance, (CreationalContext)cc);
                    cc.release();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Object[] resolve(Method method) {
        return OpenEJBEnricher.resolve((AppContext)((AppContext)this.appContext.get()), (TestClass)((TestClass)this.testClass.get()), (Method)method);
    }
}

