/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.openejb.AppContext;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.common.ArquillianUtil;
import org.apache.openejb.arquillian.openejb.OpenEJBArchiveProcessor;
import org.apache.openejb.arquillian.openejb.OpenEJBConfiguration;
import org.apache.openejb.arquillian.openejb.SWClassLoader;
import org.apache.openejb.arquillian.openejb.server.ServiceManagers;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.OpenEjbConfigurationFactory;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.cdi.ScopeHelper;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.core.LocalInitialContext;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.web.LightweightWebAppBuilder;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class OpenEJBDeployableContainer
implements DeployableContainer<OpenEJBConfiguration> {
    private static final Properties PROPERTIES = new Properties();
    private static final ConcurrentMap<String, DeploymentInfo> DEPLOYMENT_INFO;
    private Properties properties;
    private Assembler assembler;
    private InitialContext initialContext;
    private ConfigurationFactory configurationFactory;
    private Collection<Archive<?>> containerArchives;
    @Inject
    @DeploymentScoped
    private InstanceProducer<AppInfo> appInfoProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<AppContext> appContextProducer;
    @Inject
    @SuiteScoped
    private InstanceProducer<Context> contextProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<ServletContext> servletContextProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<HttpSession> sessionProducer;
    @Inject
    @SuiteScoped
    private InstanceProducer<ClassLoader> classLoader;
    @Inject
    private Instance<ServletContext> servletContext;
    @Inject
    private Instance<HttpSession> session;
    @Inject
    private Instance<AppInfo> info;
    @Inject
    private Instance<AppContext> appContext;
    @Inject
    private Instance<TestClass> testClass;
    private OpenEJBConfiguration configuration;

    public Class<OpenEJBConfiguration> getConfigurationClass() {
        return OpenEJBConfiguration.class;
    }

    public void setup(OpenEJBConfiguration openEJBConfiguration) {
        this.properties = new Properties();
        this.configuration = openEJBConfiguration;
        ByteArrayInputStream bais = new ByteArrayInputStream(openEJBConfiguration.getProperties().getBytes());
        try {
            this.properties.load(bais);
        }
        catch (IOException e) {
            throw new OpenEJBRuntimeException((Exception)e);
        }
        finally {
            IO.close((Closeable)bais);
        }
        for (Map.Entry<Object, Object> defaultKey : PROPERTIES.entrySet()) {
            String key = defaultKey.getKey().toString();
            if (this.properties.containsKey(key)) continue;
            this.properties.setProperty(key, defaultKey.getValue().toString());
        }
        ArquillianUtil.preLoadClassesAsynchronously((String)openEJBConfiguration.getPreloadClasses());
    }

    public void start() throws LifecycleException {
        try {
            this.initialContext = new InitialContext(this.properties);
        }
        catch (NamingException e) {
            throw new LifecycleException("can't start the OpenEJB container", (Throwable)e);
        }
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        this.configurationFactory = (ConfigurationFactory)SystemInstance.get().getComponent(OpenEjbConfigurationFactory.class);
        if ("true".equalsIgnoreCase(PROPERTIES.getProperty("openejb.embedded.remotable")) && SystemInstance.get().getComponent(WebAppBuilder.class) == null) {
            SystemInstance.get().setComponent(WebAppBuilder.class, (Object)new LightweightWebAppBuilder());
        }
        this.contextProducer.set((Object)this.initialContext);
        this.containerArchives = ArquillianUtil.toDeploy((Properties)this.properties);
        for (Archive<?> archive : this.containerArchives) {
            try {
                this.quickDeploy(archive, (TestClass)this.testClass.get());
            }
            catch (DeploymentException e) {
                Logger.getLogger(OpenEJBDeployableContainer.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        ProtocolMetaData metaData;
        try {
            DeploymentInfo info = this.quickDeploy(archive, (TestClass)this.testClass.get());
            this.servletContextProducer.set((Object)info.appServletContext);
            this.sessionProducer.set((Object)info.appSession);
            this.appInfoProducer.set((Object)info.appInfo);
            this.appContextProducer.set((Object)info.appCtx);
            this.classLoader.set((Object)info.appCtx.getClassLoader());
        }
        catch (Exception e) {
            throw new DeploymentException("can't deploy " + archive.getName(), (Throwable)e);
        }
        if (PROPERTIES.containsKey("openejb.embedded.remotable") && (metaData = ServiceManagers.protocolMetaData((AppInfo)this.appInfoProducer.get())) != null) {
            return metaData;
        }
        return new ProtocolMetaData();
    }

    private DeploymentInfo quickDeploy(Archive<?> archive, TestClass testClass) throws DeploymentException {
        String name = archive.getName();
        DeploymentInfo info = (DeploymentInfo)DEPLOYMENT_INFO.get(name);
        if (info == null) {
            try {
                AppModule module = OpenEJBArchiveProcessor.createModule(archive, testClass);
                AppInfo appInfo = this.configurationFactory.configureApplication(module);
                AppContext appCtx = this.assembler.createApplication(appInfo, module.getClassLoader());
                MockServletContext appServletContext = new MockServletContext();
                MockHttpSession appSession = new MockHttpSession();
                ScopeHelper.startContexts((ContextsService)appCtx.getWebBeansContext().getContextsService(), (ServletContext)appServletContext, (HttpSession)appSession);
                info = new DeploymentInfo((ServletContext)appServletContext, (HttpSession)appSession, appInfo, appCtx);
                if (this.configuration.isSingleDeploymentByArchiveName(name)) {
                    DEPLOYMENT_INFO.putIfAbsent(name, info);
                }
            }
            catch (Exception e) {
                throw new DeploymentException("can't deploy " + name, (Throwable)e);
            }
        }
        return info;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.classLoader.set((Object)OpenEJBDeployableContainer.class.getClassLoader());
        if (this.appContext.get() == null) {
            return;
        }
        ClassLoader cl = ((AppContext)this.appContext.get()).getClassLoader();
        if (SWClassLoader.class.isInstance(cl)) {
            ((SWClassLoader)SWClassLoader.class.cast(cl)).close();
        }
        try {
            if (!this.configuration.isSingleDeploymentByArchiveName(archive.getName())) {
                this.assembler.destroyApplication(((AppInfo)this.info.get()).path);
            }
            this.stopCurrentContexts();
        }
        catch (Exception e) {
            throw new DeploymentException("can't undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        ArquillianUtil.undeploy((DeployableContainer)this, this.containerArchives);
        try {
            if (this.initialContext != null) {
                this.initialContext.close();
            }
        }
        catch (NamingException e) {
            throw new LifecycleException("can't close the OpenEJB container", (Throwable)e);
        }
        finally {
            OpenEJB.destroy();
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    private void stopCurrentContexts() throws Exception {
        ScopeHelper.stopContexts((ContextsService)((AppContext)this.appContext.get()).getWebBeansContext().getContextsService(), (ServletContext)((ServletContext)this.servletContext.get()), (HttpSession)((HttpSession)this.session.get()));
    }

    static {
        PROPERTIES.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
        PROPERTIES.setProperty("openejb.embedded.initialcontext.close", LocalInitialContext.Close.DESTROY.name());
        PROPERTIES.setProperty("openejb.deployments.classpath", "false");
        try {
            OpenEJBDeployableContainer.class.getClassLoader().loadClass("org.apache.openejb.server.ServiceManager");
            PROPERTIES.setProperty("openejb.embedded.remotable", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEPLOYMENT_INFO = new ConcurrentHashMap<String, DeploymentInfo>();
    }

    private static final class DeploymentInfo {
        public final ServletContext appServletContext;
        public final HttpSession appSession;
        public final AppInfo appInfo;
        public final AppContext appCtx;

        private DeploymentInfo(ServletContext appServletContext, HttpSession appSession, AppInfo appInfo, AppContext appCtx) {
            this.appServletContext = appServletContext;
            this.appSession = appSession;
            this.appInfo = appInfo;
            this.appCtx = appCtx;
        }
    }
}

