/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal.layer;

import java.time.Duration;
import org.apache.opendal.Layer;

public class RetryLayer
extends Layer {
    private final boolean jitter;
    private final float factor;
    private final Duration minDelay;
    private final Duration maxDelay;
    private final long maxTimes;

    @Override
    protected long layer(long nativeOp) {
        return RetryLayer.doLayer(nativeOp, this.jitter, this.factor, this.minDelay.toNanos(), this.maxDelay.toNanos(), this.maxTimes);
    }

    private static native long doLayer(long var0, boolean var2, float var3, long var4, long var6, long var8);

    private static float $default$factor() {
        return 2.0f;
    }

    private static Duration $default$minDelay() {
        return Duration.ofSeconds(1L);
    }

    private static Duration $default$maxDelay() {
        return Duration.ofSeconds(60L);
    }

    private static long $default$maxTimes() {
        return 3L;
    }

    RetryLayer(boolean jitter, float factor, Duration minDelay, Duration maxDelay, long maxTimes) {
        this.jitter = jitter;
        this.factor = factor;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.maxTimes = maxTimes;
    }

    public static RetryLayerBuilder builder() {
        return new RetryLayerBuilder();
    }

    public static class RetryLayerBuilder {
        private boolean jitter;
        private boolean factor$set;
        private float factor$value;
        private boolean minDelay$set;
        private Duration minDelay$value;
        private boolean maxDelay$set;
        private Duration maxDelay$value;
        private boolean maxTimes$set;
        private long maxTimes$value;

        RetryLayerBuilder() {
        }

        public RetryLayerBuilder jitter(boolean jitter) {
            this.jitter = jitter;
            return this;
        }

        public RetryLayerBuilder factor(float factor) {
            this.factor$value = factor;
            this.factor$set = true;
            return this;
        }

        public RetryLayerBuilder minDelay(Duration minDelay) {
            this.minDelay$value = minDelay;
            this.minDelay$set = true;
            return this;
        }

        public RetryLayerBuilder maxDelay(Duration maxDelay) {
            this.maxDelay$value = maxDelay;
            this.maxDelay$set = true;
            return this;
        }

        public RetryLayerBuilder maxTimes(long maxTimes) {
            this.maxTimes$value = maxTimes;
            this.maxTimes$set = true;
            return this;
        }

        public RetryLayer build() {
            float factor$value = this.factor$value;
            if (!this.factor$set) {
                factor$value = RetryLayer.$default$factor();
            }
            Duration minDelay$value = this.minDelay$value;
            if (!this.minDelay$set) {
                minDelay$value = RetryLayer.$default$minDelay();
            }
            Duration maxDelay$value = this.maxDelay$value;
            if (!this.maxDelay$set) {
                maxDelay$value = RetryLayer.$default$maxDelay();
            }
            long maxTimes$value = this.maxTimes$value;
            if (!this.maxTimes$set) {
                maxTimes$value = RetryLayer.$default$maxTimes();
            }
            return new RetryLayer(this.jitter, factor$value, minDelay$value, maxDelay$value, maxTimes$value);
        }

        public String toString() {
            return "RetryLayer.RetryLayerBuilder(jitter=" + this.jitter + ", factor$value=" + this.factor$value + ", minDelay$value=" + this.minDelay$value + ", maxDelay$value=" + this.maxDelay$value + ", maxTimes$value=" + this.maxTimes$value + ")";
        }
    }
}

