/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import io.netty.channel.Channel;
import java.io.IOException;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.LeaseManager;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.PersistenceProcessorHandler;
import org.apache.omid.tso.PersistenceProcessorImpl;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.RetryProcessor;
import org.apache.omid.tso.RuntimeExceptionPanicker;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPersistenceProcessorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TestPersistenceProcessorHandler.class);
    private static final int BATCH_ID = 0;
    private static final int BATCH_SIZE = 6;
    private static final long BATCH_SEQUENCE = 0L;
    private static final long FIRST_ST = 0L;
    private static final long FIRST_CT = 1L;
    private static final long SECOND_ST = 2L;
    private static final long SECOND_CT = 3L;
    private static final long THIRD_ST = 4L;
    private static final long THIRD_CT = 5L;
    private static final long FOURTH_ST = 6L;
    private static final long FOURTH_CT = 7L;
    private static final long FIFTH_ST = 8L;
    private static final long FIFTH_CT = 9L;
    private static final long SIXTH_ST = 10L;
    @Mock
    private CommitTable.Writer mockWriter;
    @Mock
    private CommitTable.Client mockClient;
    @Mock
    private LeaseManager leaseManager;
    @Mock
    private ReplyProcessor replyProcessor;
    @Mock
    private RetryProcessor retryProcessor;
    @Mock
    private Panicker panicker;
    private CommitTable commitTable;
    private MetricsRegistry metrics;
    private PersistenceProcessorHandler persistenceHandler;

    @BeforeMethod(alwaysRun=true, timeOut=30000L)
    public void initMocksAndComponents() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.metrics = new NullMetricsProvider();
        this.commitTable = new CommitTable(){

            public CommitTable.Writer getWriter() {
                return TestPersistenceProcessorHandler.this.mockWriter;
            }

            public CommitTable.Client getClient() {
                return TestPersistenceProcessorHandler.this.mockClient;
            }
        };
        ((LeaseManager)Mockito.doReturn((Object)true).when((Object)this.leaseManager)).stillInLeasePeriod();
        this.persistenceHandler = (PersistenceProcessorHandler)Mockito.spy((Object)new PersistenceProcessorHandler(this.metrics, "localhost:1234", (LeaseManagement)this.leaseManager, this.commitTable, this.replyProcessor, this.retryProcessor, this.panicker));
    }

    @AfterMethod
    void afterMethod() {
        Mockito.reset((Object[])new CommitTable.Writer[]{this.mockWriter});
    }

    @Test(timeOut=1000L)
    public void testPersistentProcessorHandlerIdsAreCreatedConsecutive() throws Exception {
        int i;
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setNumConcurrentCTWriters(32);
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[tsoConfig.getNumConcurrentCTWriters()];
        for (i = 0; i < tsoConfig.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", (LeaseManagement)Mockito.mock(LeaseManager.class), this.commitTable, (ReplyProcessor)Mockito.mock(ReplyProcessor.class), this.retryProcessor, this.panicker);
        }
        for (i = 0; i < tsoConfig.getNumConcurrentCTWriters(); ++i) {
            int followingHandlerIdAsInt;
            if (i + 1 < tsoConfig.getNumConcurrentCTWriters()) {
                followingHandlerIdAsInt = Integer.valueOf(handlers[i + 1].getId());
                Assert.assertEquals((String)handlers[i].getId(), (String)String.valueOf(followingHandlerIdAsInt - 1));
                continue;
            }
            followingHandlerIdAsInt = PersistenceProcessorHandler.consecutiveSequenceCreator.get();
            Assert.assertEquals((String)handlers[i].getId(), (String)String.valueOf(followingHandlerIdAsInt - 1));
        }
    }

    @Test(timeOut=10000L)
    public void testProcessingOfEmptyBatchPersistEvent() throws Exception {
        Batch batch = new Batch(0, 6);
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)0));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.eq((Object)batch));
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.never())).disambiguateRetryRequestHeuristically(ArgumentMatchers.anyLong(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertTrue((boolean)batch.isEmpty());
    }

    @Test(timeOut=10000L)
    public void testProcessingOfBatchPersistEventWithASingleTimestampEvent() throws Exception {
        Batch batch = new Batch(0, 6);
        batch.addTimestamp(0L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)0));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.eq((Object)batch));
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.never())).disambiguateRetryRequestHeuristically(ArgumentMatchers.anyLong(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertEquals((int)batch.getNumEvents(), (int)1);
        Assert.assertEquals((long)batch.get(0).getStartTimestamp(), (long)0L);
    }

    @Test(timeOut=10000L)
    public void testProcessingOfBatchPersistEventWithASingleCommitEvent() throws Exception {
        Batch batch = new Batch(0, 6);
        batch.addCommit(0L, 1L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class), Optional.absent());
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)1));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries(batch);
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.never())).disambiguateRetryRequestHeuristically(ArgumentMatchers.anyLong(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertEquals((int)batch.getNumEvents(), (int)1);
        Assert.assertEquals((long)batch.get(0).getStartTimestamp(), (long)0L);
        Assert.assertEquals((long)batch.get(0).getCommitTimestamp(), (long)1L);
    }

    @Test(timeOut=10000L)
    public void testProcessingOfBatchPersistEventWithASingleAbortEventNoRetry() throws Exception {
        Batch batch = new Batch(0, 6);
        batch.addAbort(0L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)0));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries(batch);
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.never())).disambiguateRetryRequestHeuristically(ArgumentMatchers.anyLong(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertEquals((int)batch.getNumEvents(), (int)1);
        Assert.assertEquals((long)batch.get(0).getStartTimestamp(), (long)0L);
    }

    @Test(timeOut=10000L)
    public void testProcessingOfBatchPersistEventWithASingleCommitRetryEvent() throws Exception {
        Batch batch = new Batch(0, 6);
        batch.addCommitRetry(0L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)0));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries(batch);
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.times((int)1))).disambiguateRetryRequestHeuristically(ArgumentMatchers.eq((long)0L), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertEquals((int)batch.getNumEvents(), (int)0);
    }

    @Test(timeOut=10000L)
    public void testProcessingOfBatchPersistEventWith2EventsCommitAndCommitRetry() throws Exception {
        Batch batch = new Batch(0, 6);
        batch.addCommit(0L, 1L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class), Optional.absent());
        batch.addCommitRetry(2L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        Assert.assertEquals((int)batch.getNumEvents(), (int)2);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)1));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.eq((Object)batch));
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.times((int)1))).disambiguateRetryRequestHeuristically(ArgumentMatchers.eq((long)2L), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertEquals((int)batch.getNumEvents(), (int)1);
        Assert.assertEquals((long)batch.get(0).getStartTimestamp(), (long)0L);
        Assert.assertEquals((long)batch.get(0).getCommitTimestamp(), (long)1L);
    }

    @Test(timeOut=10000L)
    public void testProcessingOfBatchPersistEventWith2EventsCommitRetryAndCommit() throws Exception {
        Batch batch = new Batch(0, 6);
        batch.addCommitRetry(0L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        batch.addCommit(2L, 3L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class), Optional.absent());
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        Assert.assertEquals((int)batch.getNumEvents(), (int)2);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)1));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.eq((Object)batch));
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.times((int)1))).disambiguateRetryRequestHeuristically(ArgumentMatchers.eq((long)0L), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertEquals((int)batch.getNumEvents(), (int)1);
        Assert.assertEquals((long)batch.get(0).getStartTimestamp(), (long)2L);
        Assert.assertEquals((long)batch.get(0).getCommitTimestamp(), (long)3L);
    }

    @Test(timeOut=10000L)
    public void testProcessingOfBatchPersistEventWith2CommitRetryEvents() throws Exception {
        Batch batch = new Batch(0, 6);
        batch.addCommitRetry(0L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        batch.addCommitRetry(2L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        Assert.assertEquals((int)batch.getNumEvents(), (int)2);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)0));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.eq((Object)batch));
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.times((int)1))).disambiguateRetryRequestHeuristically(ArgumentMatchers.eq((long)0L), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.times((int)1))).disambiguateRetryRequestHeuristically(ArgumentMatchers.eq((long)2L), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertEquals((int)batch.getNumEvents(), (int)0);
    }

    @Test(timeOut=10000L)
    public void testProcessingOfBatchPersistEventWith2AbortEvents() throws Exception {
        Batch batch = new Batch(0, 6);
        batch.addAbort(0L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        batch.addAbort(2L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        Assert.assertEquals((int)batch.getNumEvents(), (int)2);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)0));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.eq((Object)batch));
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.never())).disambiguateRetryRequestHeuristically(ArgumentMatchers.anyLong(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertEquals((int)batch.getNumEvents(), (int)2);
        Assert.assertEquals((long)batch.get(0).getStartTimestamp(), (long)0L);
        Assert.assertEquals((long)batch.get(1).getStartTimestamp(), (long)2L);
    }

    @Test(timeOut=10000L)
    public void testProcessingOfBatchPersistEventWithMultipleRetryAndNonRetryEvents() throws Exception {
        Batch batch = new Batch(0, 6);
        batch.addTimestamp(0L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        batch.addCommitRetry(2L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        batch.addCommit(4L, 5L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class), Optional.absent());
        batch.addAbort(6L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        batch.addCommit(8L, 9L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class), Optional.absent());
        batch.addCommitRetry(10L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class));
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        Assert.assertEquals((int)batch.getNumEvents(), (int)6);
        this.persistenceHandler.onEvent(batchEvent);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(2);
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.eq((Object)batch));
        ((RetryProcessor)Mockito.verify((Object)this.retryProcessor, (VerificationMode)Mockito.times((int)1))).disambiguateRetryRequestHeuristically(ArgumentMatchers.eq((long)2L), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.times((int)1))).manageResponsesBatch(ArgumentMatchers.eq((long)0L), (Batch)ArgumentMatchers.eq((Object)batch));
        Assert.assertEquals((int)batch.getNumEvents(), (int)4);
        Assert.assertEquals((long)batch.get(0).getStartTimestamp(), (long)0L);
        Assert.assertEquals((long)batch.get(1).getStartTimestamp(), (long)8L);
        Assert.assertEquals((long)batch.get(1).getCommitTimestamp(), (long)9L);
        Assert.assertEquals((long)batch.get(2).getStartTimestamp(), (long)4L);
        Assert.assertEquals((long)batch.get(2).getCommitTimestamp(), (long)5L);
        Assert.assertEquals((long)batch.get(3).getStartTimestamp(), (long)6L);
    }

    @Test(timeOut=10000L)
    public void testPanicPersistingEvents() throws Exception {
        Panicker panicker = (Panicker)Mockito.spy((Object)new RuntimeExceptionPanicker());
        this.persistenceHandler = (PersistenceProcessorHandler)Mockito.spy((Object)new PersistenceProcessorHandler(this.metrics, "localhost:1234", (LeaseManagement)this.leaseManager, this.commitTable, this.replyProcessor, this.retryProcessor, panicker));
        Batch batch = new Batch(0, 6);
        batch.addCommit(0L, 1L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class), Optional.absent());
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        ((CommitTable.Writer)Mockito.doThrow(IOException.class).when((Object)this.mockWriter)).flush();
        try {
            this.persistenceHandler.onEvent(batchEvent);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(1);
        ((Panicker)Mockito.verify((Object)panicker, (VerificationMode)Mockito.times((int)1))).panic((String)ArgumentMatchers.eq((Object)"Error persisting commit batch"), (Throwable)ArgumentMatchers.any(IOException.class));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.never())).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.any(Batch.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.never())).manageResponsesBatch(ArgumentMatchers.anyLong(), (Batch)ArgumentMatchers.any(Batch.class));
    }

    @Test(timeOut=10000L)
    public void testPanicBecauseMasterLosesMastership() throws Exception {
        ((LeaseManager)Mockito.doReturn((Object)false).when((Object)this.leaseManager)).stillInLeasePeriod();
        Panicker panicker = (Panicker)Mockito.spy((Object)new RuntimeExceptionPanicker());
        this.persistenceHandler = (PersistenceProcessorHandler)Mockito.spy((Object)new PersistenceProcessorHandler(this.metrics, "localhost:1234", (LeaseManagement)this.leaseManager, this.commitTable, this.replyProcessor, this.retryProcessor, panicker));
        Batch batch = new Batch(0, 6);
        batch.addCommit(0L, 1L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class), Optional.absent());
        PersistenceProcessorImpl.PersistBatchEvent batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        try {
            this.persistenceHandler.onEvent(batchEvent);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)1));
        ((CommitTable.Writer)Mockito.verify((Object)this.mockWriter, (VerificationMode)Mockito.never())).flush();
        ((Panicker)Mockito.verify((Object)panicker, (VerificationMode)Mockito.times((int)1))).panic((String)ArgumentMatchers.eq((Object)"Replica localhost:1234 lost mastership whilst flushing data. Committing suicide"), (Throwable)ArgumentMatchers.any(Throwable.class));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.never())).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.any(Batch.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.never())).manageResponsesBatch(ArgumentMatchers.anyLong(), (Batch)ArgumentMatchers.any(Batch.class));
        ((LeaseManager)Mockito.doReturn((Object)true).doReturn((Object)false).when((Object)this.leaseManager)).stillInLeasePeriod();
        panicker = (Panicker)Mockito.spy((Object)new RuntimeExceptionPanicker());
        this.persistenceHandler = (PersistenceProcessorHandler)Mockito.spy((Object)new PersistenceProcessorHandler(this.metrics, "localhost:1234", (LeaseManagement)this.leaseManager, this.commitTable, this.replyProcessor, this.retryProcessor, panicker));
        batch = new Batch(0, 6);
        batch.addCommit(0L, 1L, null, (MonitoringContext)Mockito.mock(MonitoringContext.class), Optional.absent());
        batchEvent = new PersistenceProcessorImpl.PersistBatchEvent();
        PersistenceProcessorImpl.PersistBatchEvent.makePersistBatch((PersistenceProcessorImpl.PersistBatchEvent)batchEvent, (long)0L, (Batch)batch);
        try {
            this.persistenceHandler.onEvent(batchEvent);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.times((int)1))).flush(ArgumentMatchers.eq((int)1));
        ((CommitTable.Writer)Mockito.verify((Object)this.mockWriter, (VerificationMode)Mockito.times((int)1))).flush();
        ((Panicker)Mockito.verify((Object)panicker, (VerificationMode)Mockito.times((int)1))).panic((String)ArgumentMatchers.eq((Object)"Replica localhost:1234 lost mastership whilst flushing data. Committing suicide"), (Throwable)ArgumentMatchers.any(Throwable.class));
        ((PersistenceProcessorHandler)Mockito.verify((Object)this.persistenceHandler, (VerificationMode)Mockito.never())).filterAndDissambiguateClientRetries((Batch)ArgumentMatchers.any(Batch.class));
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.never())).manageResponsesBatch(ArgumentMatchers.anyLong(), (Batch)ArgumentMatchers.any(Batch.class));
    }
}

