/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.omid.tso.client.ConnectionException;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOClient;
import org.apache.omid.tso.util.DummyCellIdImpl;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.statemachine.StateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUnconnectedTSOClient {
    private static final Logger LOG = LoggerFactory.getLogger(TestUnconnectedTSOClient.class);
    private static final int TSO_RECONNECTION_DELAY_IN_SECS_FOR_TEST = 2;

    @Test(timeOut=30000L)
    public void testRequestsDoneOnAnUnconnectedTSOClientAlwaysReturn() throws Exception {
        OmidClientConfiguration tsoClientConf = new OmidClientConfiguration();
        tsoClientConf.setConnectionString("localhost:12345");
        tsoClientConf.setReconnectionDelayInSecs(2);
        TSOClient tsoClient = TSOClient.newInstance((OmidClientConfiguration)tsoClientConf);
        StateMachine.FsmImpl fsm = (StateMachine.FsmImpl)tsoClient.fsm;
        Assert.assertEquals(fsm.getState().getClass(), TSOClient.DisconnectedState.class);
        try {
            tsoClient.getNewStartTimestamp().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            LOG.info("Exception expected");
            Assert.assertEquals(e.getCause().getClass(), ConnectionException.class);
            TimeUnit.SECONDS.sleep(4L);
            Assert.assertEquals(fsm.getState().getClass(), TSOClient.DisconnectedState.class);
        }
        try {
            tsoClient.commit(1L, (Set)Sets.newHashSet((Object[])new DummyCellIdImpl[]{new DummyCellIdImpl(3735928559L)})).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            LOG.info("Exception expected");
            Assert.assertEquals(e.getCause().getClass(), ConnectionException.class);
            TimeUnit.SECONDS.sleep(4L);
            Assert.assertEquals(fsm.getState().getClass(), TSOClient.DisconnectedState.class);
        }
        tsoClient.close().get();
        LOG.info("No exception expected");
    }
}

