/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.io.IOException;
import org.apache.omid.tso.TSOStateManager;
import org.apache.omid.tso.TSOStateManagerImpl;
import org.apache.omid.tso.TimestampOracle;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestTSOStateManager {
    private static final long INITIAL_STATE_VALUE = 1L;
    private static final long NEW_STATE_VALUE = 1000L;
    private TimestampOracle timestampOracle = (TimestampOracle)Mockito.mock(TimestampOracle.class);
    private TSOStateManager stateManager = new TSOStateManagerImpl(this.timestampOracle);

    @BeforeMethod
    public void beforeMethod() {
        Mockito.when((Object)this.timestampOracle.getLast()).thenReturn((Object)1L);
    }

    @Test(timeOut=10000L)
    public void testTSOServerStateInitialization() throws Exception {
        TSOStateManager.TSOState initialState = this.stateManager.initialize();
        Assert.assertEquals((long)initialState.getLowWatermark(), (long)1L);
        Assert.assertEquals((long)initialState.getEpoch(), (long)1L);
        Assert.assertTrue((initialState.getLowWatermark() == initialState.getEpoch() ? 1 : 0) != 0, (String)"In this implementation low watermark should be equal to epoch");
        Mockito.when((Object)this.timestampOracle.getLast()).thenReturn((Object)1000L);
        TSOStateManager.TSOState secondState = this.stateManager.initialize();
        Assert.assertEquals((long)secondState.getLowWatermark(), (long)1000L);
        Assert.assertEquals((long)secondState.getEpoch(), (long)1000L);
        Assert.assertTrue((secondState.getLowWatermark() == secondState.getEpoch() ? 1 : 0) != 0, (String)"In this implementation low watermark should be equal to epoch");
    }

    @Test(timeOut=10000L)
    public void testObserverRegistrationAndDeregistrationForStateChanges() throws Exception {
        TSOStateManager.StateObserver observer1 = (TSOStateManager.StateObserver)Mockito.spy((Object)new DummyObserver());
        this.stateManager.register(observer1);
        TSOStateManager.TSOState state = this.stateManager.initialize();
        ((TSOStateManager.StateObserver)Mockito.verify((Object)observer1, (VerificationMode)Mockito.timeout((long)100L).times(1))).update((TSOStateManager.TSOState)Matchers.eq((Object)state));
        TSOStateManager.StateObserver observer2 = (TSOStateManager.StateObserver)Mockito.spy((Object)new DummyObserver());
        this.stateManager.register(observer2);
        state = this.stateManager.initialize();
        ((TSOStateManager.StateObserver)Mockito.verify((Object)observer1, (VerificationMode)Mockito.timeout((long)100L).times(1))).update((TSOStateManager.TSOState)Matchers.eq((Object)state));
        ((TSOStateManager.StateObserver)Mockito.verify((Object)observer2, (VerificationMode)Mockito.timeout((long)100L).times(1))).update((TSOStateManager.TSOState)Matchers.eq((Object)state));
        this.stateManager.unregister(observer1);
        state = this.stateManager.initialize();
        ((TSOStateManager.StateObserver)Mockito.verify((Object)observer1, (VerificationMode)Mockito.timeout((long)100L).times(0))).update((TSOStateManager.TSOState)Matchers.eq((Object)state));
        ((TSOStateManager.StateObserver)Mockito.verify((Object)observer2, (VerificationMode)Mockito.timeout((long)100L).times(1))).update((TSOStateManager.TSOState)Matchers.eq((Object)state));
    }

    private class DummyObserver
    implements TSOStateManager.StateObserver {
        private DummyObserver() {
        }

        public void update(TSOStateManager.TSOState state) throws IOException {
        }
    }
}

