/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import io.netty.channel.Channel;
import org.apache.commons.pool2.ObjectPool;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.committable.InMemoryCommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.tso.BatchPoolModule;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.MonitoringContextImpl;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.RetryProcessorImpl;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestRetryProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TestRetryProcessor.class);
    private static long NON_EXISTING_ST_TX = 1000L;
    private static long ST_TX_1 = 0L;
    private static long CT_TX_1 = 1L;
    @Mock
    private Channel channel;
    @Mock
    private ReplyProcessor replyProc;
    @Mock
    private Panicker panicker;
    @Mock
    private MetricsRegistry metrics;
    @Mock
    private MonitoringContextImpl monCtx;
    private CommitTable commitTable;

    @BeforeMethod(alwaysRun=true, timeOut=30000L)
    public void initMocksAndComponents() {
        MockitoAnnotations.initMocks((Object)this);
        this.commitTable = new InMemoryCommitTable();
    }

    @Test(timeOut=10000L)
    public void testRetriedRequestForANonExistingTxReturnsAbort() throws Exception {
        ObjectPool batchPool = new BatchPoolModule(new TSOServerConfig()).getBatchPool();
        RetryProcessorImpl retryProc = new RetryProcessorImpl((WaitStrategy)new YieldingWaitStrategy(), this.metrics, this.commitTable, this.replyProc, this.panicker, batchPool);
        retryProc.disambiguateRetryRequestHeuristically(NON_EXISTING_ST_TX, this.channel, (MonitoringContext)this.monCtx);
        ArgumentCaptor firstTSCapture = ArgumentCaptor.forClass(Long.class);
        ((ReplyProcessor)Mockito.verify((Object)this.replyProc, (VerificationMode)Mockito.timeout((long)100L).times(1))).sendAbortResponse(((Long)firstTSCapture.capture()).longValue(), (Channel)Matchers.any(), (MonitoringContext)Matchers.any(MonitoringContext.class));
        long startTS = (Long)firstTSCapture.getValue();
        Assert.assertEquals((long)startTS, (long)NON_EXISTING_ST_TX, (String)"Captured timestamp should be the same as NON_EXISTING_ST_TX");
    }

    @Test(timeOut=10000L)
    public void testRetriedRequestForAnExistingTxReturnsCommit() throws Exception {
        ObjectPool batchPool = new BatchPoolModule(new TSOServerConfig()).getBatchPool();
        RetryProcessorImpl retryProc = new RetryProcessorImpl((WaitStrategy)new YieldingWaitStrategy(), this.metrics, this.commitTable, this.replyProc, this.panicker, batchPool);
        this.commitTable.getWriter().addCommittedTransaction(ST_TX_1, CT_TX_1);
        retryProc.disambiguateRetryRequestHeuristically(ST_TX_1, this.channel, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ArgumentCaptor firstTSCapture = ArgumentCaptor.forClass(Long.class);
        ArgumentCaptor secondTSCapture = ArgumentCaptor.forClass(Long.class);
        ((ReplyProcessor)Mockito.verify((Object)this.replyProc, (VerificationMode)Mockito.timeout((long)100L).times(1))).sendCommitResponse(((Long)firstTSCapture.capture()).longValue(), ((Long)secondTSCapture.capture()).longValue(), (Channel)Matchers.any(), (MonitoringContext)Matchers.any(MonitoringContext.class), (Optional)Matchers.any(Optional.class));
        long startTS = (Long)firstTSCapture.getValue();
        long commitTS = (Long)secondTSCapture.getValue();
        Assert.assertEquals((long)startTS, (long)ST_TX_1, (String)"Captured timestamp should be the same as ST_TX_1");
        Assert.assertEquals((long)commitTS, (long)CT_TX_1, (String)"Captured timestamp should be the same as CT_TX_1");
    }

    @Test(timeOut=10000L)
    public void testRetriedRequestForInvalidatedTransactionReturnsAnAbort() throws Exception {
        this.commitTable.getClient().tryInvalidateTransaction(ST_TX_1);
        Optional invalidTxMarker = (Optional)this.commitTable.getClient().getCommitTimestamp(ST_TX_1).get();
        Assert.assertTrue((boolean)invalidTxMarker.isPresent());
        Assert.assertEquals((long)((CommitTable.CommitTimestamp)invalidTxMarker.get()).getValue(), (long)-1L);
        ObjectPool batchPool = new BatchPoolModule(new TSOServerConfig()).getBatchPool();
        RetryProcessorImpl retryProc = new RetryProcessorImpl((WaitStrategy)new YieldingWaitStrategy(), this.metrics, this.commitTable, this.replyProc, this.panicker, batchPool);
        retryProc.disambiguateRetryRequestHeuristically(ST_TX_1, this.channel, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ArgumentCaptor startTSCapture = ArgumentCaptor.forClass(Long.class);
        ((ReplyProcessor)Mockito.verify((Object)this.replyProc, (VerificationMode)Mockito.timeout((long)100L).times(1))).sendAbortResponse(((Long)startTSCapture.capture()).longValue(), (Channel)Matchers.any(), (MonitoringContext)Matchers.any(MonitoringContext.class));
        long startTS = (Long)startTSCapture.getValue();
        Assert.assertEquals((long)startTS, (long)ST_TX_1, (String)"Captured timestamp should be the same as NON_EXISTING_ST_TX");
    }
}

