/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.omid.OmidFilterBase;

public class CellSkipFilterBase
extends OmidFilterBase {
    private final Filter filter;
    private KeyValue skipColumn = null;

    public CellSkipFilterBase(Filter filter) {
        this.filter = filter;
    }

    private boolean skipCellVersion(Cell cell) {
        return this.skipColumn != null && CellUtil.matchingRow((Cell)cell, (byte[])this.skipColumn.getRowArray(), (int)this.skipColumn.getRowOffset(), (int)this.skipColumn.getRowLength()) && CellUtil.matchingFamily((Cell)cell, (byte[])this.skipColumn.getFamilyArray(), (int)this.skipColumn.getFamilyOffset(), (int)this.skipColumn.getFamilyLength()) && CellUtil.matchingQualifier((Cell)cell, (byte[])this.skipColumn.getQualifierArray(), (int)this.skipColumn.getQualifierOffset(), (int)this.skipColumn.getQualifierLength());
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        if (this.skipCellVersion(cell)) {
            return Filter.ReturnCode.NEXT_COL;
        }
        Filter.ReturnCode code = this.filter.filterKeyValue(cell);
        this.skipColumn = code == Filter.ReturnCode.NEXT_COL || code == Filter.ReturnCode.INCLUDE_AND_NEXT_COL ? KeyValueUtil.createFirstOnRow((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength(), (byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()) : null;
        return code;
    }

    public boolean filterRow() throws IOException {
        return this.filter.filterRow();
    }

    public Cell transformCell(Cell cell) throws IOException {
        return this.filter.transformCell(cell);
    }

    public void reset() throws IOException {
        this.filter.reset();
    }

    public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
        return this.filter.filterRowKey(buffer, offset, length);
    }

    public boolean filterAllRemaining() throws IOException {
        return this.filter.filterAllRemaining();
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        this.filter.filterRowCells(kvs);
    }

    public boolean hasFilterRow() {
        return this.filter.hasFilterRow();
    }

    public Cell getNextCellHint(Cell currentKV) throws IOException {
        return this.filter.getNextCellHint(currentKV);
    }

    public boolean isFamilyEssential(byte[] name) throws IOException {
        return this.filter.isFamilyEssential(name);
    }

    public byte[] toByteArray() throws IOException {
        return this.filter.toByteArray();
    }

    public Filter getInnerFilter() {
        return this.filter;
    }
}

