/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.ref.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.hsqldb.jdbc.JDBCClob;

@Converter(autoApply=true)
public class ClobToStringConverter
implements AttributeConverter<Clob, String> {
    public String convertToDatabaseColumn(Clob clob) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Reader reader = clob.getCharacterStream();
            int byteRead = reader.read();
            while (byteRead != -1) {
                os.write(byteRead);
                byteRead = reader.read();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return os.toString();
    }

    public Clob convertToEntityAttribute(String string) {
        if (string == null) {
            return null;
        }
        JDBCClob clob = null;
        try {
            clob = new JDBCClob(string);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return clob;
    }
}

