/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.api.jpql;

import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAFactory;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;

public abstract class JPQLContext
implements JPQLContextView {
    protected String jpaEntityAlias;
    protected String jpaEntityName;
    protected JPQLContextType type;
    protected boolean pagingRequested = false;

    protected final void setJPAEntityName(String jpaEntityName) {
        this.jpaEntityName = jpaEntityName;
    }

    protected final void setJPAEntityAlias(String jpaEntityAlias) {
        this.jpaEntityAlias = jpaEntityAlias;
    }

    @Override
    public final String getJPAEntityAlias() {
        return this.jpaEntityAlias;
    }

    protected final void setType(JPQLContextType type) {
        this.type = type;
    }

    @Override
    public final String getJPAEntityName() {
        return this.jpaEntityName;
    }

    @Override
    public final JPQLContextType getType() {
        return this.type;
    }

    protected void isPagingRequested(boolean pagingRequested) {
        this.pagingRequested = pagingRequested;
    }

    public static final JPQLContextBuilder createBuilder(JPQLContextType contextType, Object resultsView) throws ODataJPARuntimeException {
        return JPQLContextBuilder.create(contextType, resultsView, false);
    }

    public static final JPQLContextBuilder createBuilder(JPQLContextType contextType, Object resultsView, boolean withPaging) throws ODataJPARuntimeException {
        return JPQLContextBuilder.create(contextType, resultsView, withPaging);
    }

    public static abstract class JPQLContextBuilder {
        private static final String ALIAS = "E";
        protected int aliasCounter = 0;
        protected boolean withPaging = false;

        protected JPQLContextBuilder() {
        }

        private static JPQLContextBuilder create(JPQLContextType contextType, Object resultsView, boolean withPaging) throws ODataJPARuntimeException {
            JPQLContextBuilder contextBuilder = ODataJPAFactory.createFactory().getJPQLBuilderFactory().getContextBuilder(contextType);
            if (contextBuilder == null) {
                throw ODataJPARuntimeException.throwException(ODataJPARuntimeException.ERROR_JPQLCTXBLDR_CREATE, null);
            }
            contextBuilder.setResultsView(resultsView);
            contextBuilder.withPaging = withPaging;
            return contextBuilder;
        }

        public abstract JPQLContext build() throws ODataJPAModelException, ODataJPARuntimeException;

        protected abstract void setResultsView(Object var1);

        protected void resetAliasCounter() {
            this.aliasCounter = 0;
        }

        protected String generateJPAEntityAlias() {
            return new String(ALIAS + ++this.aliasCounter);
        }
    }
}

