/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm;

import java.io.Serializable;

public final class FullQualifiedName
implements Serializable {
    private static final long serialVersionUID = -4063629050858999076L;
    private final String namespace;
    private final String name;
    private final String fqn;

    public FullQualifiedName(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        this.fqn = namespace + "." + name;
    }

    public FullQualifiedName(String namespaceAndName) {
        int dotIdx = namespaceAndName.lastIndexOf(46);
        if (dotIdx == -1 || dotIdx == 0 || dotIdx == namespaceAndName.length() - 1) {
            throw new IllegalArgumentException("Malformed " + FullQualifiedName.class.getSimpleName() + ": " + namespaceAndName);
        }
        this.fqn = namespaceAndName;
        this.namespace = this.fqn.substring(0, dotIdx);
        this.name = this.fqn.substring(dotIdx + 1);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getFullQualifiedNameAsString() {
        return this.fqn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullQualifiedName that = (FullQualifiedName)o;
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.fqn == null ? that.fqn != null : !this.fqn.equals(that.fqn));
    }

    public int hashCode() {
        int result = this.namespace != null ? this.namespace.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.fqn != null ? this.fqn.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.fqn;
    }
}

