/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.api.domain;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataEntitySet;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataEntitySetIterator<ES extends CommonODataEntitySet, E extends CommonODataEntity>
implements Iterator<E> {
    private static final Logger LOG = LoggerFactory.getLogger(ODataEntitySetIterator.class);
    protected final CommonODataClient<?> odataClient;
    protected ResWrap<Entity> cached;
    private final InputStream stream;
    private final ODataFormat format;
    private ES entitySet;
    private final ByteArrayOutputStream osEntitySet;
    private final String namespaces;
    private boolean available = true;

    public ODataEntitySetIterator(CommonODataClient<?> odataClient, InputStream stream, ODataFormat format) {
        this.odataClient = odataClient;
        this.stream = stream;
        this.format = format;
        this.osEntitySet = new ByteArrayOutputStream();
        if (format == ODataFormat.ATOM) {
            this.namespaces = this.getAllElementAttributes(stream, "feed", this.osEntitySet);
        } else {
            this.namespaces = null;
            try {
                if (this.consume(stream, "\"value\":", this.osEntitySet, true) >= 0) {
                    int c = 0;
                    while (c != 91 && (c = stream.read()) >= 0) {
                        this.osEntitySet.write(c);
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Error parsing entity set", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.available && this.cached == null) {
            this.cached = this.format == ODataFormat.ATOM ? this.nextAtomEntityFromEntitySet(this.stream, this.osEntitySet, this.namespaces) : this.nextJSONEntityFromEntitySet(this.stream, this.osEntitySet);
            if (this.cached == null) {
                this.available = false;
                try {
                    this.entitySet = this.odataClient.getReader().readEntitySet(new ByteArrayInputStream(this.osEntitySet.toByteArray()), this.format);
                }
                catch (ODataDeserializerException e) {
                    this.available = false;
                }
                this.close();
            }
        }
        return this.available;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            CommonODataEntity res = this.odataClient.getBinder().getODataEntity(this.cached);
            this.cached = null;
            return (E)res;
        }
        throw new NoSuchElementException("No entity found");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void close() {
        IOUtils.closeQuietly((InputStream)this.stream);
        IOUtils.closeQuietly((OutputStream)this.osEntitySet);
    }

    public URI getNext() {
        if (this.entitySet == null) {
            throw new IllegalStateException("Iteration must be completed in order to retrieve the link for next page");
        }
        return this.entitySet.getNext();
    }

    private ResWrap<Entity> nextJSONEntityFromEntitySet(InputStream input, OutputStream osEntitySet) {
        ByteArrayOutputStream entity = new ByteArrayOutputStream();
        ResWrap jsonEntity = null;
        try {
            int c;
            boolean foundNewOne = false;
            do {
                if ((c = input.read()) == 123) {
                    entity.write(c);
                    c = -1;
                    foundNewOne = true;
                }
                if (c != 93) continue;
                osEntitySet.write(c);
                c = -1;
            } while (c >= 0);
            if (foundNewOne) {
                int count = 1;
                c = 0;
                while (count > 0 && c >= 0) {
                    c = input.read();
                    if (c == 123) {
                        ++count;
                    } else if (c == 125) {
                        --count;
                    }
                    entity.write(c);
                }
                if (c >= 0) {
                    jsonEntity = this.odataClient.getDeserializer(ODataFormat.JSON).toEntity(new ByteArrayInputStream(entity.toByteArray()));
                }
            } else {
                while ((c = input.read()) >= 0) {
                    osEntitySet.write(c);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving entities from EntitySet", (Throwable)e);
        }
        return jsonEntity;
    }

    private ResWrap<Entity> nextAtomEntityFromEntitySet(InputStream input, OutputStream osEntitySet, String namespaces) {
        ByteArrayOutputStream entity = new ByteArrayOutputStream();
        ResWrap atomEntity = null;
        try {
            if (this.consume(input, "<entry>", osEntitySet, false) >= 0) {
                entity.write("<entry ".getBytes("UTF-8"));
                entity.write(namespaces.getBytes("UTF-8"));
                entity.write(">".getBytes("UTF-8"));
                if (this.consume(input, "</entry>", entity, true) >= 0) {
                    atomEntity = this.odataClient.getDeserializer(ODataFormat.ATOM).toEntity(new ByteArrayInputStream(entity.toByteArray()));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving entities from EntitySet", (Throwable)e);
        }
        return atomEntity;
    }

    private String getAllElementAttributes(InputStream input, String name, OutputStream os) {
        String res;
        ByteArrayOutputStream attrs = new ByteArrayOutputStream();
        try {
            byte[] attrsDeclaration = null;
            String key = "<" + name + " ";
            if (this.consume(input, key, os, true) >= 0 && this.consume(input, ">", attrs, false) >= 0) {
                attrsDeclaration = attrs.toByteArray();
                os.write(attrsDeclaration);
                os.write(62);
            }
            res = attrsDeclaration == null ? "" : new String(attrsDeclaration, "UTF-8").trim();
        }
        catch (Exception e) {
            LOG.error("Error retrieving entities from EntitySet", (Throwable)e);
            res = "";
        }
        return res.endsWith("/") ? res.substring(0, res.length() - 1) : res;
    }

    private int consume(InputStream input, String end, OutputStream os, boolean includeEndKey) throws IOException {
        char[] endKey = end.toCharArray();
        char[] endLowerKey = end.toLowerCase().toCharArray();
        char[] endUpperKey = end.toUpperCase().toCharArray();
        int pos = 0;
        char c = '\u0000';
        while (pos < endKey.length && (c = input.read()) >= '\u0000') {
            if (c == endLowerKey[pos] || c == endUpperKey[pos]) {
                ++pos;
                if (!includeEndKey || os == null) continue;
                os.write(c);
                continue;
            }
            if (pos > 0) {
                if (!includeEndKey && os != null) {
                    for (int i = 0; i < pos; ++i) {
                        os.write(endKey[i]);
                    }
                }
                if (os != null) {
                    os.write(c);
                }
                pos = 0;
                continue;
            }
            if (os == null) continue;
            os.write(c);
        }
        return c;
    }
}

