/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.servlets;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.servlet.AsyncContext;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.ws.rs.Path;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.StandardFlowFileMediaType;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processors.standard.ListenHTTP;
import org.apache.nifi.processors.standard.exception.ListenHttpException;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.stream.io.StreamThrottler;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.FlowFileUnpackager;
import org.apache.nifi.util.FlowFileUnpackagerV1;
import org.apache.nifi.util.FlowFileUnpackagerV2;
import org.apache.nifi.util.FlowFileUnpackagerV3;

@Path(value="")
public class ListenHTTPServlet
extends HttpServlet {
    private static final long serialVersionUID = 5329940480987723163L;
    public static final String FLOWFILE_CONFIRMATION_HEADER = "x-prefer-acknowledge-uri";
    public static final String LOCATION_HEADER_NAME = "Location";
    public static final String DEFAULT_FOUND_SUBJECT = "none";
    public static final String DEFAULT_FOUND_ISSUER = "none";
    public static final String LOCATION_URI_INTENT_NAME = "x-location-uri-intent";
    public static final String LOCATION_URI_INTENT_VALUE = "flowfile-hold";
    public static final int FILES_BEFORE_CHECKING_DESTINATION_SPACE = 5;
    public static final String ACCEPT_HEADER_NAME = "Accept";
    public static final String ACCEPT_HEADER_VALUE = String.format("%s,%s,%s,%s,*/*;q=0.8", StandardFlowFileMediaType.VERSION_3.getMediaType(), StandardFlowFileMediaType.VERSION_2.getMediaType(), StandardFlowFileMediaType.VERSION_1.getMediaType(), StandardFlowFileMediaType.VERSION_UNSPECIFIED.getMediaType());
    public static final String ACCEPT_ENCODING_NAME = "Accept-Encoding";
    public static final String ACCEPT_ENCODING_VALUE = "gzip";
    public static final String GZIPPED_HEADER = "flowfile-gzipped";
    public static final String PROTOCOL_VERSION_HEADER = "x-nifi-transfer-protocol-version";
    public static final String PROTOCOL_VERSION = "3";
    protected static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private final AtomicLong filesReceived = new AtomicLong(0L);
    private final AtomicBoolean spaceAvailable = new AtomicBoolean(true);
    private ComponentLog logger;
    private AtomicReference<ProcessSessionFactory> sessionFactoryHolder;
    private volatile ProcessContext processContext;
    private Pattern authorizedPattern;
    private Pattern authorizedIssuerPattern;
    private Pattern headerPattern;
    private ConcurrentMap<String, ListenHTTP.FlowFileEntryTimeWrapper> flowFileMap;
    private StreamThrottler streamThrottler;
    private String basePath;
    private int returnCode;
    private long multipartRequestMaxSize;
    private int multipartReadBufferSize;
    private int port;
    private RecordReaderFactory readerFactory;
    private RecordSetWriterFactory writerFactory;

    public void init(ServletConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        this.logger = (ComponentLog)context.getAttribute("logger");
        this.sessionFactoryHolder = (AtomicReference)context.getAttribute("sessionFactoryHolder");
        this.processContext = (ProcessContext)context.getAttribute("processContextHolder");
        this.authorizedPattern = (Pattern)context.getAttribute("authorityPattern");
        this.authorizedIssuerPattern = (Pattern)context.getAttribute("authorityIssuerPattern");
        this.headerPattern = (Pattern)context.getAttribute("headerPattern");
        this.flowFileMap = (ConcurrentMap)context.getAttribute("flowFileMap");
        this.streamThrottler = (StreamThrottler)context.getAttribute("streamThrottler");
        this.basePath = (String)context.getAttribute("basePath");
        this.returnCode = (Integer)context.getAttribute("returnCode");
        this.multipartRequestMaxSize = (Long)context.getAttribute("multipartRequestMaxSize");
        this.multipartReadBufferSize = (Integer)context.getAttribute("multipartReadBufferSize");
        this.port = (Integer)context.getAttribute("port");
        this.readerFactory = (RecordReaderFactory)this.processContext.getProperty(ListenHTTP.RECORD_READER).asControllerService(RecordReaderFactory.class);
        this.writerFactory = (RecordSetWriterFactory)this.processContext.getProperty(ListenHTTP.RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getLocalPort() == this.port) {
            response.addHeader(ACCEPT_ENCODING_NAME, ACCEPT_ENCODING_VALUE);
            response.addHeader(ACCEPT_HEADER_NAME, ACCEPT_HEADER_VALUE);
            response.addHeader(PROTOCOL_VERSION_HEADER, PROTOCOL_VERSION);
        } else {
            super.doHead(request, response);
        }
    }

    private void notAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405, "Method Not Allowed");
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.notAllowed(request, response);
        this.logger.debug("Denying TRACE request; method not allowed.");
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.notAllowed(request, response);
        this.logger.debug("Denying OPTIONS request; method not allowed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ProcessSessionFactory sessionFactory;
        if (request.getLocalPort() != this.port) {
            super.doPost(request, response);
            return;
        }
        ProcessContext context = this.processContext;
        do {
            if ((sessionFactory = this.sessionFactoryHolder.get()) != null) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (sessionFactory == null);
        ProcessSession session = sessionFactory.createSession();
        String foundSubject = null;
        String foundIssuer = null;
        try {
            Set<FlowFile> flowFileSet;
            GZIPInputStream in;
            X509Certificate[] x509CertificateArray;
            int n;
            int n2;
            long n3 = this.filesReceived.getAndIncrement() % 5L;
            if (n3 == 0L || !this.spaceAvailable.get()) {
                if (context.getAvailableRelationships().isEmpty()) {
                    this.spaceAvailable.set(false);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received request from " + request.getRemoteHost() + " but no space available; Indicating Service Unavailable");
                    }
                    response.sendError(503);
                    return;
                }
                this.spaceAvailable.set(true);
            }
            response.setHeader("Content-Type", "text/plain");
            boolean flowFileGzipped = Boolean.parseBoolean(request.getHeader(GZIPPED_HEADER));
            String contentEncoding = request.getHeader(CONTENT_ENCODING_HEADER);
            boolean contentEncodingGzip = ACCEPT_ENCODING_VALUE.equals(contentEncoding);
            boolean contentGzipped = flowFileGzipped || contentEncodingGzip;
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            foundSubject = "none";
            foundIssuer = "none";
            if (certs != null && certs.length > 0 && (n2 = 0) < (n = (x509CertificateArray = certs).length)) {
                X509Certificate cert = x509CertificateArray[n2];
                foundSubject = cert.getSubjectDN().getName();
                foundIssuer = cert.getIssuerDN().getName();
                if (this.authorizedPattern.matcher(foundSubject).matches()) {
                    if (!this.authorizedIssuerPattern.matcher(foundIssuer).matches()) {
                        this.logger.warn("Access Forbidden [Issuer not authorized] Host [{}] Subject [{}] Issuer [{}]", new Object[]{request.getRemoteHost(), foundSubject, foundIssuer});
                        response.sendError(403, "not allowed based on issuer dn");
                        return;
                    }
                } else {
                    this.logger.warn("Access Forbidden [Subject not authorized] Host [{}] Subject [{}] Issuer [{}]", new Object[]{request.getRemoteHost(), foundSubject, foundIssuer});
                    response.sendError(403, "not allowed based on subject dn");
                    return;
                }
            }
            String destinationVersion = request.getHeader(PROTOCOL_VERSION_HEADER);
            Integer protocolVersion = null;
            if (destinationVersion != null) {
                try {
                    protocolVersion = Integer.valueOf(destinationVersion);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean destinationIsLegacyNiFi = protocolVersion == null;
            boolean createHold = Boolean.parseBoolean(request.getHeader(FLOWFILE_CONFIRMATION_HEADER));
            String contentType = request.getContentType();
            GZIPInputStream unthrottled = contentGzipped ? new GZIPInputStream((InputStream)request.getInputStream()) : request.getInputStream();
            InputStream inputStream = in = this.streamThrottler == null ? unthrottled : this.streamThrottler.newThrottledInputStream((InputStream)unthrottled);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received request from " + request.getRemoteHost() + ", createHold=" + createHold + ", content-type=" + contentType + ", gzip=" + contentGzipped);
            }
            if (StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().contains("multipart/form-data")) {
                try {
                    flowFileSet = this.handleMultipartRequest(request, session, foundSubject, foundIssuer);
                }
                finally {
                    this.deleteMultiPartFiles(request);
                }
            } else {
                flowFileSet = this.handleRequest(request, session, foundSubject, foundIssuer, destinationIsLegacyNiFi, contentType, in);
            }
            this.proceedFlow(request, response, session, foundSubject, foundIssuer, createHold, flowFileSet);
        }
        catch (Throwable t) {
            this.handleException(request, response, session, foundSubject, foundIssuer, t);
        }
    }

    private void deleteMultiPartFiles(HttpServletRequest request) {
        try {
            for (Part part : request.getParts()) {
                part.delete();
            }
        }
        catch (Exception e) {
            this.logger.warn("Delete MultiPart temporary files failed", (Throwable)e);
        }
    }

    private void handleException(HttpServletRequest request, HttpServletResponse response, ProcessSession session, String foundSubject, String foundIssuer, Throwable t) throws IOException {
        session.rollback();
        this.logger.error("Unable to receive file from Remote Host: [{}] SubjectDN [{}] IssuerDN [{}] due to {}", new Object[]{request.getRemoteHost(), foundSubject, foundIssuer, t});
        if (t instanceof ListenHttpException) {
            int returnCode = ((ListenHttpException)t).getReturnCode();
            response.sendError(returnCode, t.toString());
        } else {
            response.sendError(500, t.toString());
        }
    }

    private Set<FlowFile> handleMultipartRequest(HttpServletRequest request, ProcessSession session, String foundSubject, String foundIssuer) throws IOException, IllegalStateException, ServletException {
        HashSet<FlowFile> flowFileSet = new HashSet<FlowFile>();
        String tempDir = System.getProperty("java.io.tmpdir");
        request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(tempDir, this.multipartRequestMaxSize, this.multipartRequestMaxSize, this.multipartReadBufferSize));
        int i = 0;
        Collection requestParts = request.getParts();
        for (Part part : requestParts) {
            FlowFile flowFile = session.create();
            try (OutputStream flowFileOutputStream = session.write(flowFile);
                 InputStream partInputStream = part.getInputStream();){
                StreamUtils.copy((InputStream)partInputStream, (OutputStream)flowFileOutputStream);
            }
            flowFile = this.saveRequestDetailsAsAttributes(request, session, foundSubject, foundIssuer, flowFile);
            flowFile = this.savePartDetailsAsAttributes(session, part, flowFile, i, requestParts.size());
            flowFileSet.add(flowFile);
            ++i;
        }
        return flowFileSet;
    }

    private FlowFile savePartDetailsAsAttributes(ProcessSession session, Part part, FlowFile flowFile, int sequenceNumber, int allPartsCount) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String headerName : part.getHeaderNames()) {
            String headerValue = part.getHeader(headerName);
            this.putAttribute(attributes, "http.headers.multipart." + headerName, headerValue);
        }
        this.putAttribute(attributes, "http.multipart.size", part.getSize());
        this.putAttribute(attributes, "http.multipart.content.type", part.getContentType());
        this.putAttribute(attributes, "http.multipart.name", part.getName());
        this.putAttribute(attributes, "http.multipart.filename", part.getSubmittedFileName());
        this.putAttribute(attributes, "http.multipart.fragments.sequence.number", sequenceNumber + 1);
        this.putAttribute(attributes, "http.multipart.fragments.total.number", allPartsCount);
        return session.putAllAttributes(flowFile, attributes);
    }

    private Set<FlowFile> handleRequest(HttpServletRequest request, ProcessSession session, String foundSubject, String foundIssuer, boolean destinationIsLegacyNiFi, String contentType, InputStream in) throws IOException {
        String holdUuid = null;
        AtomicBoolean hasMoreData = new AtomicBoolean(false);
        FlowFileUnpackager unpackager = this.getFlowFileUnpackager(contentType);
        HashSet<FlowFile> flowFileSet = new HashSet<FlowFile>();
        do {
            String sourceSystemFlowFileIdentifier;
            long startNanos = System.nanoTime();
            HashMap attributes = new HashMap();
            FlowFile flowFile = session.create();
            OutputStream out = session.write(flowFile);
            try (BufferedOutputStream bos = new BufferedOutputStream(out, 65536);){
                if (unpackager == null) {
                    if (this.isRecordProcessing()) {
                        this.processRecord(in, flowFile, out);
                    } else {
                        IOUtils.copy((InputStream)in, (OutputStream)bos);
                        hasMoreData.set(false);
                    }
                } else {
                    attributes.putAll(unpackager.unpackageFlowFile(in, (OutputStream)bos));
                    if (destinationIsLegacyNiFi) {
                        if (attributes.containsKey("nf.file.name")) {
                            attributes.put(CoreAttributes.FILENAME.key(), attributes.remove("nf.file.name"));
                        }
                        if (attributes.containsKey("nf.file.path")) {
                            attributes.put(CoreAttributes.PATH.key(), attributes.remove("nf.file.path"));
                        }
                    }
                    hasMoreData.set(unpackager.hasMoreData());
                }
            }
            long transferNanos = System.nanoTime() - startNanos;
            long transferMillis = TimeUnit.MILLISECONDS.convert(transferNanos, TimeUnit.NANOSECONDS);
            String nameVal = request.getHeader(CoreAttributes.FILENAME.key());
            if (StringUtils.isNotBlank((CharSequence)nameVal)) {
                attributes.put(CoreAttributes.FILENAME.key(), nameVal);
            }
            if ((sourceSystemFlowFileIdentifier = (String)attributes.get(CoreAttributes.UUID.key())) != null) {
                sourceSystemFlowFileIdentifier = "urn:nifi:" + sourceSystemFlowFileIdentifier;
                attributes.put(CoreAttributes.UUID.key(), UUID.randomUUID().toString());
            }
            flowFile = session.putAllAttributes(flowFile, attributes);
            flowFile = this.saveRequestDetailsAsAttributes(request, session, foundSubject, foundIssuer, flowFile);
            String details = String.format("Remote DN=%s, Issuer DN=%s", foundSubject, foundIssuer);
            session.getProvenanceReporter().receive(flowFile, request.getRequestURL().toString(), sourceSystemFlowFileIdentifier, details, transferMillis);
            flowFileSet.add(flowFile);
            if (holdUuid != null) continue;
            holdUuid = flowFile.getAttribute(CoreAttributes.UUID.key());
        } while (hasMoreData.get());
        return flowFileSet;
    }

    protected void proceedFlow(HttpServletRequest request, HttpServletResponse response, ProcessSession session, String foundSubject, String foundIssuer, boolean createHold, Set<FlowFile> flowFileSet) throws IOException {
        if (createHold) {
            ListenHTTP.FlowFileEntryTimeWrapper previousWrapper;
            String uuid = UUID.randomUUID().toString();
            if (this.flowFileMap.containsKey(uuid)) {
                uuid = UUID.randomUUID().toString();
            }
            ListenHTTP.FlowFileEntryTimeWrapper wrapper = new ListenHTTP.FlowFileEntryTimeWrapper(session, flowFileSet, System.currentTimeMillis(), request.getRemoteHost());
            do {
                if ((previousWrapper = this.flowFileMap.putIfAbsent(uuid, wrapper)) == null) continue;
                uuid = UUID.randomUUID().toString();
            } while (previousWrapper != null);
            response.setStatus(303);
            String ackUri = "/" + this.basePath + "/holds/" + uuid;
            response.addHeader(LOCATION_HEADER_NAME, ackUri);
            response.addHeader(LOCATION_URI_INTENT_NAME, LOCATION_URI_INTENT_VALUE);
            response.getOutputStream().write(ackUri.getBytes(StandardCharsets.UTF_8));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Ingested {} from Remote Host: [{}] Port [{}] SubjectDN [{}] IssuerDN [{}]; placed hold on these {} files with ID {}", new Object[]{flowFileSet, request.getRemoteHost(), request.getRemotePort(), foundSubject, foundIssuer, flowFileSet.size(), uuid});
            }
        } else {
            this.logger.info("Received from Remote Host: [{}] Port [{}] SubjectDN [{}] IssuerDN [{}]; transferring to 'success'", new Object[]{request.getRemoteHost(), request.getRemotePort(), foundSubject, foundIssuer});
            session.transfer(flowFileSet, ListenHTTP.RELATIONSHIP_SUCCESS);
            AsyncContext asyncContext = request.startAsync();
            session.commitAsync(() -> {
                response.setStatus(this.returnCode);
                asyncContext.complete();
            }, t -> {
                this.logger.error("Failed to commit session. Returning error response to Remote Host: [{}] Port [{}] SubjectDN [{}] IssuerDN [{}]", new Object[]{request.getRemoteHost(), request.getRemotePort(), foundSubject, foundIssuer, t});
                response.setStatus(500);
                asyncContext.complete();
            });
        }
    }

    protected FlowFile saveRequestDetailsAsAttributes(HttpServletRequest request, ProcessSession session, String foundSubject, String foundIssuer, FlowFile flowFile) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.addMatchingRequestHeaders(request, attributes);
        flowFile = session.putAllAttributes(flowFile, attributes);
        flowFile = session.putAttribute(flowFile, "restlistener.remote.source.host", request.getRemoteHost());
        flowFile = session.putAttribute(flowFile, "restlistener.request.uri", request.getRequestURI());
        flowFile = session.putAttribute(flowFile, "restlistener.remote.user.dn", foundSubject);
        flowFile = session.putAttribute(flowFile, "restlistener.remote.issuer.dn", foundIssuer);
        return flowFile;
    }

    private void processRecord(InputStream in, FlowFile flowFile, OutputStream out) {
        try (RecordReader reader = this.readerFactory.createRecordReader(flowFile, (InputStream)new BufferedInputStream(in), this.logger);){
            RecordSet recordSet = reader.createRecordSet();
            try (RecordSetWriter writer = this.writerFactory.createWriter(this.logger, reader.getSchema(), out, flowFile);){
                writer.write(recordSet);
            }
        }
        catch (IOException | MalformedRecordException e) {
            throw new ListenHttpException("Could not process record.", e, 400);
        }
        catch (SchemaNotFoundException e) {
            throw new ListenHttpException("Could not find schema.", e, 500);
        }
    }

    private FlowFileUnpackager getFlowFileUnpackager(String contentType) {
        Object unpackager = StandardFlowFileMediaType.VERSION_3.getMediaType().equals(contentType) ? new FlowFileUnpackagerV3() : (StandardFlowFileMediaType.VERSION_2.getMediaType().equals(contentType) ? new FlowFileUnpackagerV2() : (StringUtils.startsWith((CharSequence)contentType, (CharSequence)StandardFlowFileMediaType.VERSION_UNSPECIFIED.getMediaType()) ? new FlowFileUnpackagerV1() : null));
        return unpackager;
    }

    private void addMatchingRequestHeaders(HttpServletRequest request, Map<String, String> attributes) {
        Enumeration headerEnum = request.getHeaderNames();
        while (headerEnum.hasMoreElements()) {
            String headerName = (String)headerEnum.nextElement();
            if (this.headerPattern == null || !this.headerPattern.matcher(headerName).matches()) continue;
            String headerValue = request.getHeader(headerName);
            attributes.put(headerName, headerValue);
        }
    }

    private void putAttribute(Map<String, String> map, String key, Object value) {
        if (value == null) {
            return;
        }
        this.putAttribute(map, key, value.toString());
    }

    private void putAttribute(Map<String, String> map, String key, String value) {
        if (value == null) {
            return;
        }
        map.put(key, value);
    }

    private boolean isRecordProcessing() {
        return this.readerFactory != null && this.writerFactory != null;
    }
}

