/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.flowfile.attributes.StandardFlowFileMediaType;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.MergeContent;
import org.apache.nifi.processors.standard.UnpackContent;
import org.apache.nifi.util.FlowFilePackager;
import org.apache.nifi.util.FlowFilePackagerV3;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"flowfile", "flowfile-stream", "flowfile-stream-v3", "package", "attributes"})
@CapabilityDescription(value="This processor will package FlowFile attributes and content into an output FlowFile that can be exported from NiFi and imported back into NiFi, preserving the original attributes and content.")
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="The mime.type will be changed to application/flowfile-v3")})
@SeeAlso(value={UnpackContent.class, MergeContent.class})
public class PackageFlowFile
extends AbstractProcessor {
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("max-batch-size").displayName("Maximum Batch Size").description("Maximum number of FlowFiles to package into one output FlowFile using a best effort, non guaranteed approach. Multiple input queues can produce unexpected batching behavior.").required(true).defaultValue("1").addValidator(StandardValidators.createLongValidator((long)1L, (long)10000L, (boolean)true)).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The packaged FlowFile is sent to this relationship").build();
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The FlowFiles that were used to create the package are sent to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new LinkedHashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_ORIGINAL)));
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE));

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        List flowFiles = session.get(context.getProperty(BATCH_SIZE).asInteger().intValue());
        if (flowFiles.isEmpty()) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.MIME_TYPE.key(), StandardFlowFileMediaType.VERSION_3.getMediaType());
        FlowFilePackagerV3 packager = new FlowFilePackagerV3();
        FlowFile packagedFlowFile = session.create((Collection)flowFiles);
        packagedFlowFile = session.write(packagedFlowFile, arg_0 -> PackageFlowFile.lambda$onTrigger$1(flowFiles, session, (FlowFilePackager)packager, arg_0));
        packagedFlowFile = session.putAllAttributes(packagedFlowFile, attributes);
        session.transfer(packagedFlowFile, REL_SUCCESS);
        session.transfer((Collection)flowFiles, REL_ORIGINAL);
    }

    private static /* synthetic */ void lambda$onTrigger$1(List flowFiles, ProcessSession session, FlowFilePackager packager, OutputStream out) throws IOException {
        try (BufferedOutputStream bufferedOut = new BufferedOutputStream(out);){
            for (FlowFile flowFile : flowFiles) {
                session.read(flowFile, in -> {
                    try (BufferedInputStream bufferedIn = new BufferedInputStream(in);){
                        packager.packageFlowFile((InputStream)bufferedIn, bufferedOut, flowFile.getAttributes(), flowFile.getSize());
                    }
                });
            }
        }
    }
}

