/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.StringUtils;

@PrimaryNodeOnly
@TriggerSerially
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"sql", "list", "jdbc", "table", "database"})
@CapabilityDescription(value="Generates a set of flow files, each containing attributes corresponding to metadata about a table from a database connection. Once metadata about a table has been fetched, it will not be fetched again until the Refresh Interval (if set) has elapsed, or until state has been manually cleared.")
@WritesAttributes(value={@WritesAttribute(attribute="db.table.name", description="Contains the name of a database table from the connection"), @WritesAttribute(attribute="db.table.catalog", description="Contains the name of the catalog to which the table belongs (may be null)"), @WritesAttribute(attribute="db.table.schema", description="Contains the name of the schema to which the table belongs (may be null)"), @WritesAttribute(attribute="db.table.fullname", description="Contains the fully-qualifed table name (possibly including catalog, schema, etc.)"), @WritesAttribute(attribute="db.table.type", description="Contains the type of the database table from the connection. Typical types are \"TABLE\", \"VIEW\", \"SYSTEM TABLE\", \"GLOBAL TEMPORARY\", \"LOCAL TEMPORARY\", \"ALIAS\", \"SYNONYM\""), @WritesAttribute(attribute="db.table.remarks", description="Contains the name of a database table from the connection"), @WritesAttribute(attribute="db.table.count", description="Contains the number of rows in the table")})
@Stateful(scopes={Scope.CLUSTER}, description="After performing a listing of tables, the timestamp of the query is stored. This allows the Processor to not re-list tables the next time that the Processor is run. Specifying the refresh interval in the processor properties will indicate that when the processor detects the interval has elapsed, the state will be reset and tables will be re-listed as a result. This processor is meant to be run on the primary node only.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListDatabaseTables
extends AbstractProcessor {
    public static final String DB_TABLE_NAME = "db.table.name";
    public static final String DB_TABLE_CATALOG = "db.table.catalog";
    public static final String DB_TABLE_SCHEMA = "db.table.schema";
    public static final String DB_TABLE_FULLNAME = "db.table.fullname";
    public static final String DB_TABLE_TYPE = "db.table.type";
    public static final String DB_TABLE_REMARKS = "db.table.remarks";
    public static final String DB_TABLE_COUNT = "db.table.count";
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are received are routed to success").build();
    public static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("list-db-tables-db-connection").displayName("Database Connection Pooling Service").description("The Controller Service that is used to obtain connection to database").required(true).identifiesControllerService(DBCPService.class).build();
    public static final PropertyDescriptor CATALOG = new PropertyDescriptor.Builder().name("list-db-tables-catalog").displayName("Catalog").description("The name of a catalog from which to list database tables. The name must match the catalog name as it is stored in the database. If the property is not set, the catalog name will not be used to narrow the search for tables. If the property is set to an empty string, tables without a catalog will be listed.").required(false).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor SCHEMA_PATTERN = new PropertyDescriptor.Builder().name("list-db-tables-schema-pattern").displayName("Schema Pattern").description("A pattern for matching schemas in the database. Within a pattern, \"%\" means match any substring of 0 or more characters, and \"_\" means match any one character. The pattern must match the schema name as it is stored in the database. If the property is not set, the schema name will not be used to narrow the search for tables. If the property is set to an empty string, tables without a schema will be listed.").required(false).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor TABLE_NAME_PATTERN = new PropertyDescriptor.Builder().name("list-db-tables-name-pattern").displayName("Table Name Pattern").description("A pattern for matching tables in the database. Within a pattern, \"%\" means match any substring of 0 or more characters, and \"_\" means match any one character. The pattern must match the table name as it is stored in the database. If the property is not set, all tables will be retrieved.").required(false).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor TABLE_TYPES = new PropertyDescriptor.Builder().name("list-db-tables-types").displayName("Table Types").description("A comma-separated list of table types to include. For example, some databases support TABLE and VIEW types. If the property is not set, tables of all types will be returned.").required(false).defaultValue("TABLE").addValidator(Validator.VALID).build();
    public static final PropertyDescriptor INCLUDE_COUNT = new PropertyDescriptor.Builder().name("list-db-include-count").displayName("Include Count").description("Whether to include the table's row count as a flow file attribute. This affects performance as a database query will be generated for each table in the retrieved list.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor REFRESH_INTERVAL = new PropertyDescriptor.Builder().name("list-db-refresh-interval").displayName("Refresh Interval").description("The amount of time to elapse before resetting the processor state, thereby causing all current tables to be listed. During this interval, the processor may continue to run, but tables that have already been listed will not be re-listed. However new/added tables will be listed as the processor runs. A value of zero means the state will never be automatically reset, the user must Clear State manually.").required(true).defaultValue("0 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("record-writer").displayName("Record Writer").description("Specifies the Record Writer to use for creating the listing. If not specified, one FlowFile will be created for each entity that is listed. If the Record Writer is specified, all entities will be written to a single FlowFile instead of adding attributes to individual FlowFiles.").required(false).identifiesControllerService(RecordSetWriterFactory.class).build();
    private static final List<PropertyDescriptor> propertyDescriptors;
    private static final Set<Relationship> relationships;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        HashMap<String, String> stateMapProperties;
        StateMap stateMap;
        ComponentLog logger = this.getLogger();
        DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
        String catalog = context.getProperty(CATALOG).getValue();
        String schemaPattern = context.getProperty(SCHEMA_PATTERN).getValue();
        String tableNamePattern = context.getProperty(TABLE_NAME_PATTERN).getValue();
        String[] tableTypes = context.getProperty(TABLE_TYPES).isSet() ? context.getProperty(TABLE_TYPES).getValue().split("\\s*,\\s*") : null;
        boolean includeCount = context.getProperty(INCLUDE_COUNT).asBoolean();
        long refreshInterval = context.getProperty(REFRESH_INTERVAL).asTimePeriod(TimeUnit.MILLISECONDS);
        try {
            stateMap = session.getState(Scope.CLUSTER);
            stateMapProperties = new HashMap<String, String>(stateMap.toMap());
        }
        catch (IOException ioe) {
            throw new ProcessException((Throwable)ioe);
        }
        RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        TableListingWriter writer = writerFactory == null ? new AttributeTableListingWriter(session) : new RecordTableListingWriter(session, writerFactory, this.getLogger());
        try (Connection con = dbcpService.getConnection(Collections.emptyMap());){
            writer.beginListing();
            DatabaseMetaData dbMetaData = con.getMetaData();
            try (ResultSet rs = dbMetaData.getTables(catalog, schemaPattern, tableNamePattern, tableTypes);){
                while (rs.next()) {
                    String transitUri;
                    HashMap<String, String> tableInformation;
                    String fqn;
                    String tableRemarks;
                    String tableType;
                    String tableName;
                    String tableSchema;
                    String tableCatalog;
                    block78: {
                        tableCatalog = rs.getString(1);
                        tableSchema = rs.getString(2);
                        tableName = rs.getString(3);
                        tableType = rs.getString(4);
                        tableRemarks = rs.getString(5);
                        fqn = Stream.of(tableCatalog, tableSchema, tableName).filter(segment -> !StringUtils.isEmpty((String)segment)).collect(Collectors.joining("."));
                        String lastTimestampForTable = (String)stateMapProperties.get(fqn);
                        boolean refreshTable = true;
                        try {
                            long lastRefreshed = -1L;
                            long currentTime = System.currentTimeMillis();
                            if (!StringUtils.isEmpty((String)lastTimestampForTable)) {
                                lastRefreshed = Long.parseLong(lastTimestampForTable);
                            }
                            if (lastRefreshed == -1L || refreshInterval > 0L && currentTime >= lastRefreshed + refreshInterval) {
                                stateMapProperties.remove(lastTimestampForTable);
                            } else {
                                refreshTable = false;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            this.getLogger().error("Failed to retrieve observed last table fetches from the State Manager. Will not perform query until this is accomplished.", (Throwable)nfe);
                            context.yield();
                            if (rs != null) {
                                if (var20_23 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable) {
                                        var20_23.addSuppressed(throwable);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                            if (con != null) {
                                if (var17_18 != null) {
                                    try {
                                        con.close();
                                    }
                                    catch (Throwable throwable) {
                                        var17_18.addSuppressed(throwable);
                                    }
                                } else {
                                    con.close();
                                }
                            }
                            return;
                        }
                        if (!refreshTable) continue;
                        logger.info("Found {}: {}", new Object[]{tableType, fqn});
                        tableInformation = new HashMap<String, String>();
                        if (includeCount) {
                            try (Statement st = con.createStatement();){
                                String countQuery = "SELECT COUNT(1) FROM " + fqn;
                                logger.debug("Executing query: {}", new Object[]{countQuery});
                                try (ResultSet countResult = st.executeQuery(countQuery);){
                                    if (!countResult.next()) break block78;
                                    tableInformation.put(DB_TABLE_COUNT, Long.toString(countResult.getLong(1)));
                                }
                            }
                            catch (SQLException se) {
                                logger.error("Couldn't get row count for {}", new Object[]{fqn});
                                continue;
                            }
                        }
                    }
                    if (tableCatalog != null) {
                        tableInformation.put(DB_TABLE_CATALOG, tableCatalog);
                    }
                    if (tableSchema != null) {
                        tableInformation.put(DB_TABLE_SCHEMA, tableSchema);
                    }
                    tableInformation.put(DB_TABLE_NAME, tableName);
                    tableInformation.put(DB_TABLE_FULLNAME, fqn);
                    tableInformation.put(DB_TABLE_TYPE, tableType);
                    if (tableRemarks != null) {
                        tableInformation.put(DB_TABLE_REMARKS, tableRemarks);
                    }
                    try {
                        transitUri = dbMetaData.getURL();
                    }
                    catch (SQLException sqle) {
                        transitUri = "<unknown>";
                    }
                    writer.addToListing(tableInformation, transitUri);
                    stateMapProperties.put(fqn, Long.toString(System.currentTimeMillis()));
                }
                writer.finishListing();
            }
            session.replaceState(stateMap, stateMapProperties, Scope.CLUSTER);
        }
        catch (IOException | SQLException | SchemaNotFoundException e) {
            writer.finishListingExceptionally((Exception)e);
            session.rollback();
            throw new ProcessException(e);
        }
    }

    static {
        ArrayList<PropertyDescriptor> _propertyDescriptors = new ArrayList<PropertyDescriptor>();
        _propertyDescriptors.add(DBCP_SERVICE);
        _propertyDescriptors.add(CATALOG);
        _propertyDescriptors.add(SCHEMA_PATTERN);
        _propertyDescriptors.add(TABLE_NAME_PATTERN);
        _propertyDescriptors.add(TABLE_TYPES);
        _propertyDescriptors.add(INCLUDE_COUNT);
        _propertyDescriptors.add(RECORD_WRITER);
        _propertyDescriptors.add(REFRESH_INTERVAL);
        propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        relationships = Collections.unmodifiableSet(_relationships);
    }

    static class RecordTableListingWriter
    implements TableListingWriter {
        private static final RecordSchema RECORD_SCHEMA;
        public static final String TABLE_NAME = "tableName";
        public static final String TABLE_CATALOG = "catalog";
        public static final String TABLE_SCHEMA = "schemaName";
        public static final String TABLE_FULLNAME = "fullName";
        public static final String TABLE_TYPE = "tableType";
        public static final String TABLE_REMARKS = "remarks";
        public static final String TABLE_ROW_COUNT = "rowCount";
        private final ProcessSession session;
        private final RecordSetWriterFactory writerFactory;
        private final ComponentLog logger;
        private RecordSetWriter recordWriter;
        private FlowFile flowFile;
        private String transitUri;

        public RecordTableListingWriter(ProcessSession session, RecordSetWriterFactory writerFactory, ComponentLog logger) {
            this.session = session;
            this.writerFactory = writerFactory;
            this.logger = logger;
        }

        @Override
        public void beginListing() throws IOException, SchemaNotFoundException {
            this.flowFile = this.session.create();
            OutputStream out = this.session.write(this.flowFile);
            this.recordWriter = this.writerFactory.createWriter(this.logger, RECORD_SCHEMA, out, this.flowFile);
            this.recordWriter.beginRecordSet();
        }

        @Override
        public void addToListing(Map<String, String> tableInfo, String transitUri) throws IOException {
            this.transitUri = transitUri;
            this.recordWriter.write(this.createRecordForListing(tableInfo));
        }

        @Override
        public void finishListing() throws IOException {
            WriteResult writeResult = this.recordWriter.finishRecordSet();
            this.recordWriter.close();
            if (writeResult.getRecordCount() == 0) {
                this.session.remove(this.flowFile);
            } else {
                HashMap<String, String> attributes = new HashMap<String, String>(writeResult.getAttributes());
                attributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
                this.flowFile = this.session.putAllAttributes(this.flowFile, attributes);
                this.session.transfer(this.flowFile, REL_SUCCESS);
                this.session.getProvenanceReporter().receive(this.flowFile, this.transitUri);
            }
        }

        @Override
        public void finishListingExceptionally(Exception cause) {
            try {
                this.recordWriter.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to write listing as Records due to {}", new Object[]{e, e});
            }
            this.session.remove(this.flowFile);
        }

        private Record createRecordForListing(Map<String, String> tableInfo) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(TABLE_NAME, tableInfo.get(ListDatabaseTables.DB_TABLE_NAME));
            values.put(TABLE_FULLNAME, tableInfo.get(ListDatabaseTables.DB_TABLE_FULLNAME));
            values.put(TABLE_CATALOG, tableInfo.get(ListDatabaseTables.DB_TABLE_CATALOG));
            values.put(TABLE_REMARKS, tableInfo.get(ListDatabaseTables.DB_TABLE_REMARKS));
            values.put(TABLE_SCHEMA, tableInfo.get(ListDatabaseTables.DB_TABLE_SCHEMA));
            values.put(TABLE_TYPE, tableInfo.get(ListDatabaseTables.DB_TABLE_TYPE));
            String rowCountString = tableInfo.get(ListDatabaseTables.DB_TABLE_COUNT);
            if (rowCountString != null) {
                values.put(TABLE_ROW_COUNT, Long.parseLong(rowCountString));
            }
            return new MapRecord(RECORD_SCHEMA, values);
        }

        static {
            ArrayList<RecordField> fields = new ArrayList<RecordField>();
            fields.add(new RecordField(TABLE_NAME, RecordFieldType.STRING.getDataType(), false));
            fields.add(new RecordField(TABLE_CATALOG, RecordFieldType.STRING.getDataType()));
            fields.add(new RecordField(TABLE_SCHEMA, RecordFieldType.STRING.getDataType()));
            fields.add(new RecordField(TABLE_FULLNAME, RecordFieldType.STRING.getDataType(), false));
            fields.add(new RecordField(TABLE_TYPE, RecordFieldType.STRING.getDataType(), false));
            fields.add(new RecordField(TABLE_REMARKS, RecordFieldType.STRING.getDataType(), false));
            fields.add(new RecordField(TABLE_ROW_COUNT, RecordFieldType.LONG.getDataType(), false));
            RECORD_SCHEMA = new SimpleRecordSchema(fields);
        }
    }

    private static class AttributeTableListingWriter
    implements TableListingWriter {
        private final ProcessSession session;

        public AttributeTableListingWriter(ProcessSession session) {
            this.session = session;
        }

        @Override
        public void beginListing() {
        }

        @Override
        public void addToListing(Map<String, String> tableInformation, String transitUri) {
            FlowFile flowFile = this.session.create();
            flowFile = this.session.putAllAttributes(flowFile, tableInformation);
            this.session.getProvenanceReporter().receive(flowFile, transitUri);
            this.session.transfer(flowFile, REL_SUCCESS);
        }

        @Override
        public void finishListing() {
        }

        @Override
        public void finishListingExceptionally(Exception cause) {
        }
    }

    static interface TableListingWriter {
        public void beginListing() throws IOException, SchemaNotFoundException;

        public void addToListing(Map<String, String> var1, String var2) throws IOException;

        public void finishListing() throws IOException;

        public void finishListingExceptionally(Exception var1);
    }
}

