/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ssl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.util.CertificateUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.ssl.SSLContextService;

@Tags(value={"ssl", "secure", "certificate", "keystore", "truststore", "jks", "p12", "pkcs12", "pkcs", "tls"})
@CapabilityDescription(value="Standard implementation of the SSLContextService. Provides the ability to configure keystore and/or truststore properties once and reuse that configuration throughout the application. This service can be used to communicate with both legacy and modern systems. If you only need to communicate with non-legacy systems, then the StandardRestrictedSSLContextService is recommended as it only allows a specific set of SSL protocols to be chosen.")
public class StandardSSLContextService
extends AbstractControllerService
implements SSLContextService {
    public static final String STORE_TYPE_JKS = "JKS";
    public static final String STORE_TYPE_PKCS12 = "PKCS12";
    public static final PropertyDescriptor TRUSTSTORE = new PropertyDescriptor.Builder().name("Truststore Filename").description("The fully-qualified filename of the Truststore").defaultValue(null).addValidator(StandardSSLContextService.createFileExistsAndReadableValidator()).sensitive(false).build();
    public static final PropertyDescriptor TRUSTSTORE_TYPE = new PropertyDescriptor.Builder().name("Truststore Type").description("The Type of the Truststore. Either JKS or PKCS12").allowableValues(new String[]{"JKS", "PKCS12"}).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor TRUSTSTORE_PASSWORD = new PropertyDescriptor.Builder().name("Truststore Password").description("The password for the Truststore").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor KEYSTORE = new PropertyDescriptor.Builder().name("Keystore Filename").description("The fully-qualified filename of the Keystore").defaultValue(null).addValidator(StandardSSLContextService.createFileExistsAndReadableValidator()).sensitive(false).build();
    public static final PropertyDescriptor KEYSTORE_TYPE = new PropertyDescriptor.Builder().name("Keystore Type").description("The Type of the Keystore").allowableValues(new String[]{"JKS", "PKCS12"}).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor KEYSTORE_PASSWORD = new PropertyDescriptor.Builder().name("Keystore Password").defaultValue(null).description("The password for the Keystore").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    static final PropertyDescriptor KEY_PASSWORD = new PropertyDescriptor.Builder().name("key-password").displayName("Key Password").description("The password for the key. If this is not specified, but the Keystore Filename, Password, and Type are specified, then the Keystore Password will be assumed to be the same as the Key Password.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).required(false).build();
    public static final PropertyDescriptor SSL_ALGORITHM = new PropertyDescriptor.Builder().name("SSL Protocol").displayName("TLS Protocol").defaultValue("TLS").required(false).allowableValues(SSLContextService.buildAlgorithmAllowableValues()).description("The algorithm to use for this TLS/SSL context").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    private static final List<PropertyDescriptor> properties;
    protected ConfigurationContext configContext;
    private boolean isValidated;
    private static final int VALIDATION_CACHE_EXPIRATION = 5;
    private int validationCacheCount = 0;

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        this.configContext = context;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        results.addAll(StandardSSLContextService.validateStore(context.getProperties(), KeystoreValidationGroup.KEYSTORE));
        results.addAll(StandardSSLContextService.validateStore(context.getProperties(), KeystoreValidationGroup.TRUSTSTORE));
        if (!results.isEmpty()) {
            StringBuilder sb = new StringBuilder((Object)((Object)this) + " is not valid due to:");
            for (ValidationResult result : results) {
                sb.append("\n").append(result.toString());
            }
            throw new InitializationException(sb.toString());
        }
        if (StandardSSLContextService.countNulls(context.getProperty(KEYSTORE).getValue(), context.getProperty(KEYSTORE_PASSWORD).getValue(), context.getProperty(KEYSTORE_TYPE).getValue(), context.getProperty(TRUSTSTORE).getValue(), context.getProperty(TRUSTSTORE_PASSWORD).getValue(), context.getProperty(TRUSTSTORE_TYPE).getValue()) >= 4) {
            throw new InitializationException((Object)((Object)this) + " does not have the KeyStore or the TrustStore populated");
        }
        this.createSSLContext(SSLContextService.ClientAuth.REQUIRED);
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        super.onPropertyModified(descriptor, oldValue, newValue);
        this.resetValidationCache();
    }

    private static Validator createFileExistsAndReadableValidator() {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                File file = new File(input);
                boolean valid = file.exists() && file.canRead();
                String explanation = valid ? null : "File " + file + " does not exist or cannot be read";
                return new ValidationResult.Builder().subject(subject).input(input).valid(valid).explanation(explanation).build();
            }
        };
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (this.isValidated) {
            ++this.validationCacheCount;
            if (this.validationCacheCount > 5) {
                this.resetValidationCache();
            } else {
                return results;
            }
        }
        results.addAll(StandardSSLContextService.validateStore(validationContext.getProperties(), KeystoreValidationGroup.KEYSTORE));
        results.addAll(StandardSSLContextService.validateStore(validationContext.getProperties(), KeystoreValidationGroup.TRUSTSTORE));
        if (StandardSSLContextService.countNulls(validationContext.getProperty(KEYSTORE).getValue(), validationContext.getProperty(KEYSTORE_PASSWORD).getValue(), validationContext.getProperty(KEYSTORE_TYPE).getValue(), validationContext.getProperty(TRUSTSTORE).getValue(), validationContext.getProperty(TRUSTSTORE_PASSWORD).getValue(), validationContext.getProperty(TRUSTSTORE_TYPE).getValue()) >= 4) {
            results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName() + " : " + this.getIdentifier()).valid(false).explanation("Does not have the KeyStore or the TrustStore populated").build());
        }
        if (results.isEmpty()) {
            try {
                this.verifySslConfig(validationContext);
            }
            catch (ProcessException e) {
                results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName() + " : " + this.getIdentifier()).valid(false).explanation(e.getMessage()).build());
            }
        }
        this.isValidated = results.isEmpty();
        return results;
    }

    private void resetValidationCache() {
        this.validationCacheCount = 0;
        this.isValidated = false;
    }

    protected int getValidationCacheExpiration() {
        return 5;
    }

    protected String getSSLProtocolForValidation(ValidationContext validationContext) {
        return validationContext.getProperty(SSL_ALGORITHM).getValue();
    }

    private void verifySslConfig(ValidationContext validationContext) throws ProcessException {
        String protocol = this.getSSLProtocolForValidation(validationContext);
        try {
            PropertyValue keyPasswdProp = validationContext.getProperty(KEY_PASSWORD);
            char[] keyPassword = keyPasswdProp.isSet() ? keyPasswdProp.getValue().toCharArray() : null;
            String keystoreFile = validationContext.getProperty(KEYSTORE).getValue();
            if (keystoreFile == null) {
                SslContextFactory.createTrustSslContext((String)validationContext.getProperty(TRUSTSTORE).getValue(), (char[])validationContext.getProperty(TRUSTSTORE_PASSWORD).getValue().toCharArray(), (String)validationContext.getProperty(TRUSTSTORE_TYPE).getValue(), (String)protocol);
                return;
            }
            String truststoreFile = validationContext.getProperty(TRUSTSTORE).getValue();
            if (truststoreFile == null) {
                SslContextFactory.createSslContext((String)validationContext.getProperty(KEYSTORE).getValue(), (char[])validationContext.getProperty(KEYSTORE_PASSWORD).getValue().toCharArray(), (char[])keyPassword, (String)validationContext.getProperty(KEYSTORE_TYPE).getValue(), (String)protocol);
                return;
            }
            SslContextFactory.createSslContext((String)validationContext.getProperty(KEYSTORE).getValue(), (char[])validationContext.getProperty(KEYSTORE_PASSWORD).getValue().toCharArray(), (char[])keyPassword, (String)validationContext.getProperty(KEYSTORE_TYPE).getValue(), (String)validationContext.getProperty(TRUSTSTORE).getValue(), (char[])validationContext.getProperty(TRUSTSTORE_PASSWORD).getValue().toCharArray(), (String)validationContext.getProperty(TRUSTSTORE_TYPE).getValue(), (SslContextFactory.ClientAuth)SslContextFactory.ClientAuth.REQUIRED, (String)protocol);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public SSLContext createSSLContext(SSLContextService.ClientAuth clientAuth) throws ProcessException {
        String protocol = this.getSslAlgorithm();
        try {
            PropertyValue keyPasswdProp = this.configContext.getProperty(KEY_PASSWORD);
            char[] keyPassword = keyPasswdProp.isSet() ? keyPasswdProp.getValue().toCharArray() : null;
            String keystoreFile = this.configContext.getProperty(KEYSTORE).getValue();
            if (keystoreFile == null) {
                return SslContextFactory.createTrustSslContext((String)this.configContext.getProperty(TRUSTSTORE).getValue(), (char[])this.configContext.getProperty(TRUSTSTORE_PASSWORD).getValue().toCharArray(), (String)this.configContext.getProperty(TRUSTSTORE_TYPE).getValue(), (String)protocol);
            }
            String truststoreFile = this.configContext.getProperty(TRUSTSTORE).getValue();
            if (truststoreFile == null) {
                return SslContextFactory.createSslContext((String)this.configContext.getProperty(KEYSTORE).getValue(), (char[])this.configContext.getProperty(KEYSTORE_PASSWORD).getValue().toCharArray(), (char[])keyPassword, (String)this.configContext.getProperty(KEYSTORE_TYPE).getValue(), (String)protocol);
            }
            return SslContextFactory.createSslContext((String)this.configContext.getProperty(KEYSTORE).getValue(), (char[])this.configContext.getProperty(KEYSTORE_PASSWORD).getValue().toCharArray(), (char[])keyPassword, (String)this.configContext.getProperty(KEYSTORE_TYPE).getValue(), (String)this.configContext.getProperty(TRUSTSTORE).getValue(), (char[])this.configContext.getProperty(TRUSTSTORE_PASSWORD).getValue().toCharArray(), (String)this.configContext.getProperty(TRUSTSTORE_TYPE).getValue(), (SslContextFactory.ClientAuth)SslContextFactory.ClientAuth.valueOf((String)clientAuth.name()), (String)protocol);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public String getTrustStoreFile() {
        return this.configContext.getProperty(TRUSTSTORE).getValue();
    }

    public String getTrustStoreType() {
        return this.configContext.getProperty(TRUSTSTORE_TYPE).getValue();
    }

    public String getTrustStorePassword() {
        return this.configContext.getProperty(TRUSTSTORE_PASSWORD).getValue();
    }

    public boolean isTrustStoreConfigured() {
        return this.getTrustStoreFile() != null && this.getTrustStorePassword() != null && this.getTrustStoreType() != null;
    }

    public String getKeyStoreFile() {
        return this.configContext.getProperty(KEYSTORE).getValue();
    }

    public String getKeyStoreType() {
        return this.configContext.getProperty(KEYSTORE_TYPE).getValue();
    }

    public String getKeyStorePassword() {
        return this.configContext.getProperty(KEYSTORE_PASSWORD).getValue();
    }

    public String getKeyPassword() {
        return this.configContext.getProperty(KEY_PASSWORD).getValue();
    }

    public boolean isKeyStoreConfigured() {
        return this.getKeyStoreFile() != null && this.getKeyStorePassword() != null && this.getKeyStoreType() != null;
    }

    public String getSslAlgorithm() {
        return this.configContext.getProperty(SSL_ALGORITHM).getValue();
    }

    private static Collection<ValidationResult> validateStore(Map<PropertyDescriptor, String> properties, KeystoreValidationGroup keyStoreOrTrustStore) {
        String type;
        String password;
        String filename;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (keyStoreOrTrustStore == KeystoreValidationGroup.KEYSTORE) {
            filename = properties.get(KEYSTORE);
            password = properties.get(KEYSTORE_PASSWORD);
            type = properties.get(KEYSTORE_TYPE);
        } else {
            filename = properties.get(TRUSTSTORE);
            password = properties.get(TRUSTSTORE_PASSWORD);
            type = properties.get(TRUSTSTORE_TYPE);
        }
        String keystoreDesc = keyStoreOrTrustStore == KeystoreValidationGroup.KEYSTORE ? "Keystore" : "Truststore";
        int nulls = StandardSSLContextService.countNulls(filename, password, type);
        if (nulls != 3 && nulls != 0) {
            results.add(new ValidationResult.Builder().valid(false).explanation("Must set either 0 or 3 properties for " + keystoreDesc).subject(keystoreDesc + " Properties").build());
        } else if (nulls == 0) {
            File file = new File(filename);
            if (!file.exists() || !file.canRead()) {
                results.add(new ValidationResult.Builder().valid(false).subject(keystoreDesc + " Properties").explanation("Cannot access file " + file.getAbsolutePath()).build());
            } else {
                try {
                    boolean storeValid = CertificateUtils.isStoreValid((URL)file.toURI().toURL(), (KeystoreType)KeystoreType.valueOf((String)type), (char[])password.toCharArray());
                    if (!storeValid) {
                        results.add(new ValidationResult.Builder().subject(keystoreDesc + " Properties").valid(false).explanation("Invalid KeyStore Password or Type specified for file " + filename).build());
                    }
                }
                catch (MalformedURLException e) {
                    results.add(new ValidationResult.Builder().subject(keystoreDesc + " Properties").valid(false).explanation("Malformed URL from file: " + e).build());
                }
            }
        }
        return results;
    }

    private static int countNulls(Object ... objects) {
        int count = 0;
        for (Object x : objects) {
            if (x != null) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return "SSLContextService[id=" + this.getIdentifier() + "]";
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(KEYSTORE);
        props.add(KEYSTORE_PASSWORD);
        props.add(KEY_PASSWORD);
        props.add(KEYSTORE_TYPE);
        props.add(TRUSTSTORE);
        props.add(TRUSTSTORE_PASSWORD);
        props.add(TRUSTSTORE_TYPE);
        props.add(SSL_ALGORITHM);
        properties = Collections.unmodifiableList(props);
    }

    public static enum KeystoreValidationGroup {
        KEYSTORE,
        TRUSTSTORE;

    }
}

