/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.security.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.framework.security.util.SslContextCreationException;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.util.NiFiProperties;

public final class SslContextFactory {
    public static SSLContext createSslContext(NiFiProperties props) throws SslContextCreationException {
        if (!SslContextFactory.hasKeystoreProperties(props)) {
            return null;
        }
        if (!SslContextFactory.hasTruststoreProperties(props)) {
            throw new SslContextCreationException("SSL context cannot be created because truststore properties have not been configured.");
        }
        try {
            KeyStore trustStore;
            if (SslContextFactory.hasTruststoreProperties(props)) {
                trustStore = KeyStoreUtils.getTrustStore((String)props.getProperty("nifi.security.truststoreType"));
                try (FileInputStream trustStoreStream = new FileInputStream(props.getProperty("nifi.security.truststore"));){
                    trustStore.load(trustStoreStream, props.getProperty("nifi.security.truststorePasswd").toCharArray());
                }
            } else {
                trustStore = null;
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            KeyStore keyStore = KeyStoreUtils.getKeyStore((String)props.getProperty("nifi.security.keystoreType"));
            try (FileInputStream keyStoreStream = new FileInputStream(props.getProperty("nifi.security.keystore"));){
                keyStore.load(keyStoreStream, props.getProperty("nifi.security.keystorePasswd").toCharArray());
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (StringUtils.isNotBlank((CharSequence)props.getProperty("nifi.security.keyPasswd"))) {
                keyManagerFactory.init(keyStore, props.getProperty("nifi.security.keyPasswd").toCharArray());
            } else {
                keyManagerFactory.init(keyStore, props.getProperty("nifi.security.keystorePasswd").toCharArray());
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            sslContext.getDefaultSSLParameters().setNeedClientAuth(true);
            return sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new SslContextCreationException(e);
        }
    }

    private static boolean hasKeystoreProperties(NiFiProperties props) {
        return StringUtils.isNotBlank((CharSequence)props.getProperty("nifi.security.keystore")) && StringUtils.isNotBlank((CharSequence)props.getProperty("nifi.security.keystorePasswd")) && StringUtils.isNotBlank((CharSequence)props.getProperty("nifi.security.keystoreType"));
    }

    private static boolean hasTruststoreProperties(NiFiProperties props) {
        return StringUtils.isNotBlank((CharSequence)props.getProperty("nifi.security.truststore")) && StringUtils.isNotBlank((CharSequence)props.getProperty("nifi.security.truststoreType"));
    }
}

