/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.security.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.nifi.framework.security.util.SslContextFactory;
import org.apache.nifi.framework.security.util.SslSocketFactoryCreationException;
import org.apache.nifi.util.NiFiProperties;

public class SslSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory sslSocketFactory;

    public SslSocketFactory(NiFiProperties nifiProperties) {
        SSLContext sslCtx = SslContextFactory.createSslContext(nifiProperties);
        if (sslCtx == null) {
            try {
                this.sslSocketFactory = SSLContext.getDefault().getSocketFactory();
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SslSocketFactoryCreationException(nsae);
            }
        } else {
            this.sslSocketFactory = sslCtx.getSocketFactory();
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int i, boolean bln) throws IOException {
        return this.sslSocketFactory.createSocket(socket, string, i, bln);
    }

    @Override
    public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
        return this.sslSocketFactory.createSocket(ia, i, ia1, i1);
    }

    @Override
    public Socket createSocket(InetAddress ia, int i) throws IOException {
        return this.sslSocketFactory.createSocket(ia, i);
    }

    @Override
    public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException, UnknownHostException {
        return this.sslSocketFactory.createSocket(string, i, ia, i1);
    }

    @Override
    public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
        return this.sslSocketFactory.createSocket(string, i);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.sslSocketFactory.createSocket();
    }
}

