/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.security.krb.AbstractKerberosUser;
import org.apache.nifi.security.krb.ConfigurationUtil;

public class KerberosPasswordUser
extends AbstractKerberosUser {
    private final String password;

    public KerberosPasswordUser(String principal, String password) {
        super(principal);
        this.password = password;
        Validate.notBlank((CharSequence)this.password);
    }

    @Override
    protected LoginContext createLoginContext(Subject subject) throws LoginException {
        PasswordConfig configuration = new PasswordConfig();
        UsernamePasswordCallbackHandler callbackHandler = new UsernamePasswordCallbackHandler(this.principal, this.password);
        return new LoginContext("PasswordConf", subject, callbackHandler, configuration);
    }

    private static class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public UsernamePasswordCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
            Validate.notBlank((CharSequence)this.username);
            Validate.notBlank((CharSequence)this.password);
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    passwordCallback.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new IllegalStateException("Unexpected callback type: " + callback.getClass().getCanonicalName());
            }
        }
    }

    private static class PasswordConfig
    extends Configuration {
        private PasswordConfig() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("storeKey", "true");
            options.put("refreshKrb5Config", "true");
            String krbLoginModuleName = ConfigurationUtil.IS_IBM ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
            return new AppConfigurationEntry[]{new AppConfigurationEntry(krbLoginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

