/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.kms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.nifi.security.kms.FileBasedKeyProvider;
import org.apache.nifi.security.kms.StaticKeyProvider;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.AESKeyedCipherProvider;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtils {
    private static final Logger logger = LoggerFactory.getLogger(StaticKeyProvider.class);
    private static final String STATIC_KEY_PROVIDER_CLASS_NAME = "org.apache.nifi.security.kms.StaticKeyProvider";
    private static final String FILE_BASED_KEY_PROVIDER_CLASS_NAME = "org.apache.nifi.security.kms.FileBasedKeyProvider";
    private static final String LEGACY_SKP_FQCN = "org.apache.nifi.provenance.StaticKeyProvider";
    private static final String LEGACY_FBKP_FQCN = "org.apache.nifi.provenance.FileBasedKeyProvider";
    private static final Pattern HEX_PATTERN = Pattern.compile("(?i)^[0-9a-f]+$");
    private static final List<Integer> UNLIMITED_KEY_LENGTHS = Arrays.asList(32, 48, 64);
    public static final int IV_LENGTH = 16;

    public static boolean isUnlimitedStrengthCryptoAvailable() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Tried to determine if unlimited strength crypto is available but the AES algorithm is not available");
            return false;
        }
    }

    public static boolean isEmpty(String src) {
        return src == null || src.trim().isEmpty();
    }

    public static byte[] concatByteArrays(byte[] ... arrays) throws IOException {
        int totalByteLength = 0;
        for (byte[] bytes : arrays) {
            totalByteLength += bytes.length;
        }
        byte[] totalBytes = new byte[totalByteLength];
        int currentLength = 0;
        for (byte[] bytes : arrays) {
            System.arraycopy(bytes, 0, totalBytes, currentLength, bytes.length);
            currentLength += bytes.length;
        }
        return totalBytes;
    }

    public static boolean isValidKeyProvider(String keyProviderImplementation, String keyProviderLocation, String keyId, Map<String, String> encryptionKeys) {
        logger.debug("Attempting to validate the key provider: keyProviderImplementation = " + keyProviderImplementation + " , keyProviderLocation = " + keyProviderLocation + " , keyId = " + keyId + " , encryptionKeys = " + (encryptionKeys == null ? "0" : Integer.valueOf(encryptionKeys.size())));
        try {
            keyProviderImplementation = CryptoUtils.handleLegacyPackages(keyProviderImplementation);
        }
        catch (KeyManagementException e) {
            logger.error("The attempt to validate the key provider failed keyProviderImplementation = " + keyProviderImplementation + " , keyProviderLocation = " + keyProviderLocation + " , keyId = " + keyId + " , encryptionKeys = " + (encryptionKeys == null ? "0" : Integer.valueOf(encryptionKeys.size())));
            return false;
        }
        if (STATIC_KEY_PROVIDER_CLASS_NAME.equals(keyProviderImplementation)) {
            if (encryptionKeys == null) {
                return false;
            }
            boolean everyKeyValid = encryptionKeys.values().stream().allMatch(CryptoUtils::keyIsValid);
            return everyKeyValid && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)keyId);
        }
        if (FILE_BASED_KEY_PROVIDER_CLASS_NAME.equals(keyProviderImplementation)) {
            File kpf = new File(keyProviderLocation);
            return kpf.exists() && kpf.canRead() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)keyId);
        }
        logger.error("The attempt to validate the key provider failed keyProviderImplementation = " + keyProviderImplementation + " , keyProviderLocation = " + keyProviderLocation + " , keyId = " + keyId + " , encryptionKeys = " + (encryptionKeys == null ? "0" : Integer.valueOf(encryptionKeys.size())));
        return false;
    }

    static String handleLegacyPackages(String implementationClassName) throws KeyManagementException {
        if (StringUtils.isBlank((String)implementationClassName)) {
            throw new KeyManagementException("Invalid key provider implementation provided: " + implementationClassName);
        }
        if (implementationClassName.equalsIgnoreCase(LEGACY_SKP_FQCN)) {
            return StaticKeyProvider.class.getName();
        }
        if (implementationClassName.equalsIgnoreCase(LEGACY_FBKP_FQCN)) {
            return FileBasedKeyProvider.class.getName();
        }
        return implementationClassName;
    }

    public static boolean keyIsValid(String encryptionKeyHex) {
        return CryptoUtils.isHexString(encryptionKeyHex) && (CryptoUtils.isUnlimitedStrengthCryptoAvailable() ? UNLIMITED_KEY_LENGTHS.contains(encryptionKeyHex.length()) : encryptionKeyHex.length() == 32);
    }

    public static boolean isHexString(String hexString) {
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)hexString) && HEX_PATTERN.matcher(hexString).matches();
    }

    public static SecretKey formKeyFromHex(String keyHex) throws KeyManagementException {
        if (CryptoUtils.keyIsValid(keyHex)) {
            return new SecretKeySpec(Hex.decode((String)keyHex), "AES");
        }
        throw new KeyManagementException("The provided key material is not valid");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, SecretKey> readKeys(String filepath, SecretKey masterKey) throws KeyManagementException {
        HashMap<String, SecretKey> keys = new HashMap<String, SecretKey>();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)filepath)) {
            throw new KeyManagementException("The key provider file is not present and readable");
        }
        if (masterKey == null) {
            throw new KeyManagementException("The master key must be provided to decrypt the individual keys");
        }
        File file = new File(filepath);
        if (!file.exists()) throw new KeyManagementException("The key provider file is not present and readable");
        if (!file.canRead()) {
            throw new KeyManagementException("The key provider file is not present and readable");
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            AESKeyedCipherProvider masterCipherProvider = new AESKeyedCipherProvider();
            int l = 1;
            while ((line = br.readLine()) != null) {
                CharSequence keyId;
                CharSequence[] components = line.split("=", 2);
                if (components.length != 2 || org.apache.commons.lang3.StringUtils.isAnyEmpty((CharSequence[])components)) {
                    logger.warn("Line " + l + " is not properly formatted -- keyId=Base64EncodedKey...");
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(keyId = components[0]))) {
                    try {
                        byte[] base64Bytes = Base64.getDecoder().decode((String)components[1]);
                        byte[] ivBytes = Arrays.copyOfRange(base64Bytes, 0, 16);
                        Cipher masterCipher = null;
                        try {
                            masterCipher = masterCipherProvider.getCipher(EncryptionMethod.AES_GCM, masterKey, ivBytes, false);
                        }
                        catch (Exception e) {
                            throw new KeyManagementException("Error building cipher to decrypt FileBaseKeyProvider definition at " + filepath, e);
                        }
                        byte[] individualKeyBytes = masterCipher.doFinal(Arrays.copyOfRange(base64Bytes, 16, base64Bytes.length));
                        SecretKeySpec key = new SecretKeySpec(individualKeyBytes, "AES");
                        logger.debug("Read and decrypted key for " + (String)keyId);
                        if (keys.containsKey(keyId)) {
                            logger.warn("Multiple key values defined for " + (String)keyId + " -- using most recent value");
                        }
                        keys.put((String)keyId, key);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error("Encountered an error decoding Base64 for " + (String)keyId + ": " + e.getLocalizedMessage());
                    }
                    catch (BadPaddingException | IllegalBlockSizeException e) {
                        logger.error("Encountered an error decrypting key for " + (String)keyId + ": " + e.getLocalizedMessage());
                    }
                }
                ++l;
            }
            if (keys.isEmpty()) {
                throw new KeyManagementException("The provided file contained no valid keys");
            }
            logger.info("Read " + keys.size() + " keys from FileBasedKeyProvider " + filepath);
            HashMap<String, SecretKey> hashMap = keys;
            return hashMap;
        }
        catch (IOException e) {
            throw new KeyManagementException("Error reading FileBasedKeyProvider definition at " + filepath, e);
        }
    }

    public static boolean isProvenanceRepositoryEncryptionConfigured(NiFiProperties niFiProperties) {
        String implementationClassName = niFiProperties.getProperty("nifi.provenance.repository.implementation");
        boolean encryptedRepo = "org.apache.nifi.provenance.EncryptedWriteAheadProvenanceRepository".equals(implementationClassName);
        boolean keyProviderConfigured = CryptoUtils.isValidKeyProvider(niFiProperties.getProperty("nifi.provenance.repository.encryption.key.provider.implementation"), niFiProperties.getProperty("nifi.provenance.repository.encryption.key.provider.location"), niFiProperties.getProvenanceRepoEncryptionKeyId(), niFiProperties.getProvenanceRepoEncryptionKeys());
        return encryptedRepo && keyProviderConfigured;
    }
}

