/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.util.ClientAuth;
import org.apache.nifi.security.util.TlsException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUtils {
    private static final Logger logger = LoggerFactory.getLogger(CertificateUtils.class);
    private static final String PEER_NOT_AUTHENTICATED_MSG = "peer not authenticated";
    private static final Map<ASN1ObjectIdentifier, Integer> dnOrderMap = CertificateUtils.createDnOrderMap();
    public static final String JAVA_8_MAX_SUPPORTED_TLS_PROTOCOL_VERSION = "TLSv1.2";
    public static final String JAVA_11_MAX_SUPPORTED_TLS_PROTOCOL_VERSION = "TLSv1.3";
    public static final String[] JAVA_8_SUPPORTED_TLS_PROTOCOL_VERSIONS = new String[]{"TLSv1.2"};
    public static final String[] JAVA_11_SUPPORTED_TLS_PROTOCOL_VERSIONS = new String[]{"TLSv1.3", "TLSv1.2"};
    private static long lastSerialNumberMillis;
    private static int serialNumberIncrementor;
    private static BigInteger millisecondBigInteger;

    private static Map<ASN1ObjectIdentifier, Integer> createDnOrderMap() {
        HashMap<ASN1ObjectIdentifier, Integer> orderMap = new HashMap<ASN1ObjectIdentifier, Integer>();
        int count = 0;
        orderMap.put(BCStyle.CN, count++);
        orderMap.put(BCStyle.L, count++);
        orderMap.put(BCStyle.ST, count++);
        orderMap.put(BCStyle.O, count++);
        orderMap.put(BCStyle.OU, count++);
        orderMap.put(BCStyle.C, count++);
        orderMap.put(BCStyle.STREET, count++);
        orderMap.put(BCStyle.DC, count++);
        orderMap.put(BCStyle.UID, count++);
        return Collections.unmodifiableMap(orderMap);
    }

    public static String extractUsername(String dn) {
        String username = dn;
        if (StringUtils.isNotBlank((CharSequence)dn)) {
            String[] dnParts;
            String separator = StringUtils.indexOfIgnoreCase((CharSequence)dn, (CharSequence)"/cn=") > 0 ? "/" : ",";
            String cnPattern = "cn=";
            int cnIndex = StringUtils.indexOfIgnoreCase((CharSequence)dn, (CharSequence)"cn=");
            if (cnIndex >= 0) {
                int separatorIndex = StringUtils.indexOf((CharSequence)dn, (CharSequence)separator, (int)cnIndex);
                username = separatorIndex > 0 ? StringUtils.substring((String)dn, (int)(cnIndex + "cn=".length()), (int)separatorIndex) : StringUtils.substring((String)dn, (int)(cnIndex + "cn=".length()));
            }
            String emailPattern = "/emailAddress=";
            int index = StringUtils.indexOfIgnoreCase((CharSequence)username, (CharSequence)"/emailAddress=");
            if (index >= 0 && (dnParts = username.split("/emailAddress=")).length > 0) {
                username = dnParts[0];
            }
        }
        return username;
    }

    public static List<String> getSubjectAlternativeNames(java.security.cert.X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
        if (altNames == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (List<?> generalName : altNames) {
            Object value = generalName.get(1);
            if (!(value instanceof String)) continue;
            result.add(((String)value).toLowerCase());
        }
        return result;
    }

    public static String extractPeerDNFromSSLSocket(Socket socket) throws CertificateException {
        String dn = null;
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            boolean clientMode = sslSocket.getUseClientMode();
            logger.debug("SSL Socket in {} mode", (Object)(clientMode ? "client" : "server"));
            ClientAuth clientAuth = CertificateUtils.getClientAuthStatus(sslSocket);
            logger.debug("SSL Socket client auth status: {}", (Object)clientAuth);
            if (clientMode) {
                logger.debug("This socket is in client mode, so attempting to extract certificate from remote 'server' socket");
                dn = CertificateUtils.extractPeerDNFromServerSSLSocket(sslSocket);
            } else {
                logger.debug("This socket is in server mode, so attempting to extract certificate from remote 'client' socket");
                dn = CertificateUtils.extractPeerDNFromClientSSLSocket(sslSocket);
            }
        }
        return dn;
    }

    private static String extractPeerDNFromClientSSLSocket(SSLSocket sslSocket) throws CertificateException {
        String dn = null;
        ClientAuth clientAuth = CertificateUtils.getClientAuthStatus(sslSocket);
        logger.debug("SSL Socket client auth status: {}", (Object)clientAuth);
        if (clientAuth != ClientAuth.NONE) {
            try {
                Certificate[] certChains = sslSocket.getSession().getPeerCertificates();
                if (certChains != null && certChains.length > 0) {
                    java.security.cert.X509Certificate x509Certificate = CertificateUtils.convertAbstractX509Certificate(certChains[0]);
                    dn = x509Certificate.getSubjectDN().getName().trim();
                    logger.debug("Extracted DN={} from client certificate", (Object)dn);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                if (e.getMessage().equals(PEER_NOT_AUTHENTICATED_MSG)) {
                    logger.error("The incoming request did not contain client certificates and thus the DN cannot be extracted. Check that the other endpoint is providing a complete client certificate chain");
                }
                if (clientAuth == ClientAuth.WANT) {
                    logger.warn("Suppressing missing client certificate exception because client auth is set to 'want'");
                    return null;
                }
                throw new CertificateException(e);
            }
        }
        return dn;
    }

    private static String extractPeerDNFromServerSSLSocket(Socket socket) throws CertificateException {
        String dn = null;
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            try {
                Certificate[] certChains = sslSocket.getSession().getPeerCertificates();
                if (certChains != null && certChains.length > 0) {
                    java.security.cert.X509Certificate x509Certificate = CertificateUtils.convertAbstractX509Certificate(certChains[0]);
                    dn = x509Certificate.getSubjectDN().getName().trim();
                    logger.debug("Extracted DN={} from server certificate", (Object)dn);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                if (e.getMessage().equals(PEER_NOT_AUTHENTICATED_MSG)) {
                    logger.error("The server did not present a certificate and thus the DN cannot be extracted. Check that the other endpoint is providing a complete certificate chain");
                }
                throw new CertificateException(e);
            }
        }
        return dn;
    }

    private static ClientAuth getClientAuthStatus(SSLSocket sslSocket) {
        return sslSocket.getNeedClientAuth() ? ClientAuth.REQUIRED : (sslSocket.getWantClientAuth() ? ClientAuth.WANT : ClientAuth.NONE);
    }

    public static java.security.cert.X509Certificate convertLegacyX509Certificate(X509Certificate legacyCertificate) throws CertificateException {
        if (legacyCertificate == null) {
            throw new IllegalArgumentException("The X.509 certificate cannot be null");
        }
        try {
            return CertificateUtils.formX509Certificate(legacyCertificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new CertificateException(e);
        }
    }

    public static java.security.cert.X509Certificate convertAbstractX509Certificate(Certificate abstractCertificate) throws CertificateException {
        if (abstractCertificate == null || !(abstractCertificate instanceof java.security.cert.X509Certificate)) {
            throw new IllegalArgumentException("The certificate cannot be null and must be an X.509 certificate");
        }
        try {
            return CertificateUtils.formX509Certificate(abstractCertificate.getEncoded());
        }
        catch (java.security.cert.CertificateEncodingException e) {
            throw new CertificateException(e);
        }
    }

    private static java.security.cert.X509Certificate formX509Certificate(byte[] encodedCertificate) throws CertificateException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(encodedCertificate);
            return (java.security.cert.X509Certificate)cf.generateCertificate(bais);
        }
        catch (CertificateException e) {
            logger.error("Error converting the certificate", (Throwable)e);
            throw e;
        }
    }

    public static String reorderDn(String dn) {
        RDN[] rdNs = new X500Name(dn).getRDNs();
        Arrays.sort(rdNs, new Comparator<RDN>(){

            @Override
            public int compare(RDN o1, RDN o2) {
                AttributeTypeAndValue o1First = o1.getFirst();
                AttributeTypeAndValue o2First = o2.getFirst();
                ASN1ObjectIdentifier o1Type = o1First.getType();
                ASN1ObjectIdentifier o2Type = o2First.getType();
                Integer o1Rank = (Integer)dnOrderMap.get(o1Type);
                Integer o2Rank = (Integer)dnOrderMap.get(o2Type);
                if (o1Rank == null) {
                    if (o2Rank == null) {
                        int idComparison = o1Type.getId().compareTo(o2Type.getId());
                        if (idComparison != 0) {
                            return idComparison;
                        }
                        return String.valueOf(o1Type).compareTo(String.valueOf(o2Type));
                    }
                    return 1;
                }
                if (o2Rank == null) {
                    return -1;
                }
                return o1Rank - o2Rank;
            }
        });
        return new X500Name(rdNs).toString();
    }

    private static X500Name reverseX500Name(X500Name x500Name) {
        List<RDN> rdns = Arrays.asList(x500Name.getRDNs());
        Collections.reverse(rdns);
        return new X500Name(rdns.toArray(new RDN[rdns.size()]));
    }

    protected static synchronized BigInteger getUniqueSerialNumber() {
        int incrementorValue;
        long currentTimeMillis = System.currentTimeMillis();
        if (lastSerialNumberMillis != currentTimeMillis) {
            millisecondBigInteger = BigInteger.valueOf(currentTimeMillis).shiftLeft(32);
            lastSerialNumberMillis = currentTimeMillis;
            incrementorValue = 0;
            serialNumberIncrementor = 1;
        } else {
            incrementorValue = serialNumberIncrementor++;
        }
        return millisecondBigInteger.add(BigInteger.valueOf(incrementorValue));
    }

    public static java.security.cert.X509Certificate generateSelfSignedX509Certificate(KeyPair keyPair, String dn, String signingAlgorithm, int certificateDurationDays) throws CertificateException {
        return CertificateUtils.generateSelfSignedX509Certificate(keyPair, dn, signingAlgorithm, certificateDurationDays, null);
    }

    public static java.security.cert.X509Certificate generateSelfSignedX509Certificate(KeyPair keyPair, String dn, String signingAlgorithm, int certificateDurationDays, String[] dnsSubjectAlternativeNames) throws CertificateException {
        try {
            ContentSigner sigGen = new JcaContentSignerBuilder(signingAlgorithm).setProvider("BC").build(keyPair.getPrivate());
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            Date startDate = new Date();
            Date endDate = new Date(startDate.getTime() + TimeUnit.DAYS.toMillis(certificateDurationDays));
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(CertificateUtils.reverseX500Name(new X500Name(dn)), CertificateUtils.getUniqueSerialNumber(), startDate, endDate, CertificateUtils.reverseX500Name(new X500Name(dn)), subPubKeyInfo);
            certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(254));
            certBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
            certBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createSubjectKeyIdentifier(keyPair.getPublic()));
            certBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(keyPair.getPublic()));
            certBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth}));
            String cn = CertificateUtils.getCommonName(dn);
            ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
            if (StringUtils.isNotBlank((CharSequence)cn)) {
                generalNames.add(new GeneralName(2, cn));
            }
            if (dnsSubjectAlternativeNames != null) {
                for (String subjectAlternativeName : dnsSubjectAlternativeNames) {
                    if (!StringUtils.isNotBlank((CharSequence)subjectAlternativeName)) continue;
                    generalNames.add(new GeneralName(2, subjectAlternativeName));
                }
            }
            if (!generalNames.isEmpty()) {
                certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(generalNames.toArray(new GeneralName[generalNames.size()])));
            }
            X509CertificateHolder certificateHolder = certBuilder.build(sigGen);
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
        }
        catch (NoSuchAlgorithmException | CertIOException | OperatorCreationException e) {
            throw new CertificateException(e);
        }
    }

    public static java.security.cert.X509Certificate generateIssuedCertificate(String dn, PublicKey publicKey, java.security.cert.X509Certificate issuer, KeyPair issuerKeyPair, String signingAlgorithm, int days) throws CertificateException {
        return CertificateUtils.generateIssuedCertificate(dn, publicKey, null, issuer, issuerKeyPair, signingAlgorithm, days);
    }

    public static java.security.cert.X509Certificate generateIssuedCertificate(String dn, PublicKey publicKey, Extensions extensions, java.security.cert.X509Certificate issuer, KeyPair issuerKeyPair, String signingAlgorithm, int days) throws CertificateException {
        try {
            ContentSigner sigGen = new JcaContentSignerBuilder(signingAlgorithm).setProvider("BC").build(issuerKeyPair.getPrivate());
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            Date startDate = new Date();
            Date endDate = new Date(startDate.getTime() + TimeUnit.DAYS.toMillis(days));
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(CertificateUtils.reverseX500Name(new X500Name(issuer.getSubjectX500Principal().getName())), CertificateUtils.getUniqueSerialNumber(), startDate, endDate, CertificateUtils.reverseX500Name(new X500Name(dn)), subPubKeyInfo);
            certBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createSubjectKeyIdentifier(publicKey));
            certBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(issuerKeyPair.getPublic()));
            certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(248));
            certBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
            certBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth}));
            if (extensions != null && extensions.getExtension(Extension.subjectAlternativeName) != null) {
                certBuilder.addExtension(Extension.subjectAlternativeName, false, extensions.getExtensionParsedValue(Extension.subjectAlternativeName));
            }
            X509CertificateHolder certificateHolder = certBuilder.build(sigGen);
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
        }
        catch (NoSuchAlgorithmException | CertIOException | OperatorCreationException e) {
            throw new CertificateException(e);
        }
    }

    public static boolean compareDNs(String dn1, String dn2) {
        if (dn1 == null) {
            dn1 = "";
        }
        if (dn2 == null) {
            dn2 = "";
        }
        if (StringUtils.isEmpty((CharSequence)dn1) || StringUtils.isEmpty((CharSequence)dn2)) {
            return dn1.equals(dn2);
        }
        try {
            List<Rdn> rdn1 = new LdapName(dn1).getRdns();
            List<Rdn> rdn2 = new LdapName(dn2).getRdns();
            return rdn1.size() == rdn2.size() && rdn1.containsAll(rdn2);
        }
        catch (InvalidNameException e) {
            logger.warn("Cannot compare DNs: {} and {} because one or both is not a valid DN", (Object)dn1, (Object)dn2);
            return false;
        }
    }

    public static Extensions getExtensionsFromCSR(JcaPKCS10CertificationRequest csr) {
        Attribute[] attributess;
        for (Attribute attribute : attributess = csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) {
            ASN1Set attValue = attribute.getAttrValues();
            if (attValue == null) continue;
            ASN1Encodable extension = attValue.getObjectAt(0);
            if (extension instanceof Extensions) {
                return (Extensions)extension;
            }
            if (!(extension instanceof DERSequence) && !(extension instanceof DLSequence)) continue;
            return Extensions.getInstance((Object)extension);
        }
        return null;
    }

    public static boolean isTlsError(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof CertificateException || e instanceof TlsException || e instanceof SSLException) {
            return true;
        }
        if (e.getCause() != null) {
            return CertificateUtils.isTlsError(e.getCause());
        }
        return false;
    }

    public static String getCommonName(String dn) {
        RDN[] rdns = new X500Name(dn).getRDNs(BCStyle.CN);
        if (rdns.length == 0) {
            return null;
        }
        return IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue());
    }

    private CertificateUtils() {
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        lastSerialNumberMillis = 0L;
        serialNumberIncrementor = 0;
    }
}

