/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUtils {
    private static final Logger logger = LoggerFactory.getLogger(CertificateUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStoreValid(URL keystore, KeystoreType keystoreType, char[] password) {
        if (keystore == null) {
            throw new IllegalArgumentException("keystore may not be null");
        }
        if (keystoreType == null) {
            throw new IllegalArgumentException("keystore type may not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password may not be null");
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(keystore.openStream());
            KeyStore ks = KeyStore.getInstance(keystoreType.name());
            ks.load(bis, password);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close input stream", (Throwable)ioe);
                }
            }
        }
    }

    public static String extractUsername(String dn) {
        String username = dn;
        String cn = "";
        if (StringUtils.isNotBlank((CharSequence)dn)) {
            if (dn.startsWith("CN=")) {
                cn = StringUtils.substringBetween((String)dn, (String)"CN=", (String)",");
            } else if (dn.startsWith("/CN=")) {
                cn = StringUtils.substringBetween((String)dn, (String)"CN=", (String)"/");
            } else if (dn.startsWith("C=") || dn.startsWith("/C=")) {
                cn = StringUtils.substringAfter((String)dn, (String)"CN=");
            } else if (dn.startsWith("/") && StringUtils.contains((CharSequence)dn, (CharSequence)"CN=")) {
                cn = StringUtils.substringAfter((String)dn, (String)"CN=");
            }
            if (StringUtils.isNotBlank((CharSequence)cn)) {
                username = cn.endsWith(")") ? StringUtils.substringBetween((String)cn, (String)"(", (String)")") : (cn.contains(" ") ? StringUtils.substringAfterLast((String)cn, (String)" ") : cn);
            }
        }
        return username;
    }

    public static List<String> getSubjectAlternativeNames(X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
        if (altNames == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (List<?> generalName : altNames) {
            Object value = generalName.get(1);
            if (!(value instanceof String)) continue;
            result.add(((String)value).toLowerCase());
        }
        return result;
    }

    private CertificateUtils() {
    }
}

