/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.util.metrics;

import com.yammer.metrics.core.VirtualMachineMetrics;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;

public class MetricsService {
    public Map<String, String> getMetrics(ProcessGroupStatus status, boolean appendPgId) {
        HashMap<String, String> metrics = new HashMap<String, String>();
        Map<String, Long> longMetrics = this.getLongMetrics(status, appendPgId);
        for (String key : longMetrics.keySet()) {
            metrics.put(key, String.valueOf(longMetrics.get(key)));
        }
        Map<String, Integer> integerMetrics = this.getIntegerMetrics(status, appendPgId);
        for (String key : integerMetrics.keySet()) {
            metrics.put(key, String.valueOf(integerMetrics.get(key)));
        }
        return metrics;
    }

    private Map<String, Integer> getIntegerMetrics(ProcessGroupStatus status, boolean appendPgId) {
        HashMap<String, Integer> metrics = new HashMap<String, Integer>();
        metrics.put(this.appendPgId("FlowFilesReceivedLast5Minutes", status, appendPgId), status.getFlowFilesReceived());
        metrics.put(this.appendPgId("FlowFilesSentLast5Minutes", status, appendPgId), status.getFlowFilesSent());
        metrics.put(this.appendPgId("FlowFilesQueued", status, appendPgId), status.getQueuedCount());
        metrics.put(this.appendPgId("ActiveThreads", status, appendPgId), status.getActiveThreadCount());
        return metrics;
    }

    private Map<String, Long> getLongMetrics(ProcessGroupStatus status, boolean appendPgId) {
        HashMap<String, Long> metrics = new HashMap<String, Long>();
        metrics.put(this.appendPgId("BytesReceivedLast5Minutes", status, appendPgId), status.getBytesReceived());
        metrics.put(this.appendPgId("BytesSentLast5Minutes", status, appendPgId), status.getBytesSent());
        metrics.put(this.appendPgId("BytesQueued", status, appendPgId), status.getQueuedContentSize());
        metrics.put(this.appendPgId("BytesReadLast5Minutes", status, appendPgId), status.getBytesRead());
        metrics.put(this.appendPgId("BytesWrittenLast5Minutes", status, appendPgId), status.getBytesWritten());
        long durationNanos = this.calculateProcessingNanos(status);
        metrics.put(this.appendPgId("TotalTaskDurationNanoSeconds", status, appendPgId), durationNanos);
        long durationSeconds = TimeUnit.SECONDS.convert(durationNanos, TimeUnit.NANOSECONDS);
        metrics.put(this.appendPgId("TotalTaskDurationSeconds", status, appendPgId), durationSeconds);
        return metrics;
    }

    public Map<String, String> getMetrics(VirtualMachineMetrics virtualMachineMetrics) {
        HashMap<String, String> metrics = new HashMap<String, String>();
        Map<String, Integer> integerMetrics = this.getIntegerMetrics(virtualMachineMetrics);
        for (String string : integerMetrics.keySet()) {
            metrics.put(string, String.valueOf(integerMetrics.get(string)));
        }
        Map<String, Long> longMetrics = this.getLongMetrics(virtualMachineMetrics);
        for (String key : longMetrics.keySet()) {
            metrics.put(key, String.valueOf(longMetrics.get(key)));
        }
        Map<String, Double> map = this.getDoubleMetrics(virtualMachineMetrics);
        for (String key : map.keySet()) {
            metrics.put(key, String.valueOf(map.get(key)));
        }
        return metrics;
    }

    protected long calculateProcessingNanos(ProcessGroupStatus status) {
        long nanos = 0L;
        for (ProcessorStatus procStats : status.getProcessorStatus()) {
            nanos += procStats.getProcessingNanos();
        }
        for (ProcessGroupStatus childGroupStatus : status.getProcessGroupStatus()) {
            nanos += this.calculateProcessingNanos(childGroupStatus);
        }
        return nanos;
    }

    private String appendPgId(String name, ProcessGroupStatus status, boolean appendPgId) {
        if (appendPgId) {
            return name + "." + status.getId();
        }
        return name;
    }

    private Map<String, Double> getDoubleMetrics(VirtualMachineMetrics virtualMachineMetrics) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("jvm.heap_used", virtualMachineMetrics.heapUsed());
        metrics.put("jvm.heap_usage", virtualMachineMetrics.heapUsage());
        metrics.put("jvm.non_heap_usage", virtualMachineMetrics.nonHeapUsage());
        metrics.put("jvm.file_descriptor_usage", virtualMachineMetrics.fileDescriptorUsage());
        return metrics;
    }

    private Map<String, Long> getLongMetrics(VirtualMachineMetrics virtualMachineMetrics) {
        HashMap<String, Long> metrics = new HashMap<String, Long>();
        metrics.put("jvm.uptime", virtualMachineMetrics.uptime());
        for (Map.Entry entry : virtualMachineMetrics.garbageCollectors().entrySet()) {
            String gcName = ((String)entry.getKey()).replace(" ", "");
            long runs = ((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getRuns();
            long timeMS = ((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getTime(TimeUnit.MILLISECONDS);
            metrics.put("jvm.gc.runs." + gcName, runs);
            metrics.put("jvm.gc.time." + gcName, timeMS);
        }
        return metrics;
    }

    private Map<String, Integer> getIntegerMetrics(VirtualMachineMetrics virtualMachineMetrics) {
        HashMap<String, Integer> metrics = new HashMap<String, Integer>();
        metrics.put("jvm.daemon_thread_count", virtualMachineMetrics.daemonThreadCount());
        metrics.put("jvm.thread_count", virtualMachineMetrics.threadCount());
        for (Map.Entry entry : virtualMachineMetrics.threadStatePercentages().entrySet()) {
            int normalizedValue = (int)(100.0 * (entry.getValue() == null ? 0.0 : (Double)entry.getValue()));
            switch ((Thread.State)((Object)entry.getKey())) {
                case BLOCKED: {
                    metrics.put("jvm.thread_states.blocked", normalizedValue);
                    break;
                }
                case RUNNABLE: {
                    metrics.put("jvm.thread_states.runnable", normalizedValue);
                    break;
                }
                case TERMINATED: {
                    metrics.put("jvm.thread_states.terminated", normalizedValue);
                    break;
                }
                case TIMED_WAITING: {
                    metrics.put("jvm.thread_states.timed_waiting", normalizedValue);
                    break;
                }
            }
        }
        return metrics;
    }

    public JsonObject getMetrics(JsonBuilderFactory factory, ProcessGroupStatus status, VirtualMachineMetrics virtualMachineMetrics, String applicationId, String id, String hostname, long currentTimeMillis, int availableProcessors, double systemLoad) {
        JsonObjectBuilder objectBuilder = factory.createObjectBuilder().add("appid", applicationId).add("hostname", hostname).add("instanceid", status.getId()).add("timestamp", currentTimeMillis);
        objectBuilder.add("availableCores", availableProcessors).add("loadAverage1min", systemLoad);
        Map<String, Integer> integerMetrics = this.getIntegerMetrics(virtualMachineMetrics);
        for (String string : integerMetrics.keySet()) {
            objectBuilder.add(string.replaceAll("\\.", ""), integerMetrics.get(string).intValue());
        }
        Map<String, Long> longMetrics = this.getLongMetrics(virtualMachineMetrics);
        for (String string : longMetrics.keySet()) {
            objectBuilder.add(string.replaceAll("\\.", ""), longMetrics.get(string).longValue());
        }
        Map<String, Double> map = this.getDoubleMetrics(virtualMachineMetrics);
        for (String string : map.keySet()) {
            objectBuilder.add(string.replaceAll("\\.", ""), map.get(string).doubleValue());
        }
        Map<String, Long> map2 = this.getLongMetrics(status, false);
        for (String key : map2.keySet()) {
            objectBuilder.add(key, map2.get(key).longValue());
        }
        Map<String, Integer> map3 = this.getIntegerMetrics(status, false);
        for (String key : map3.keySet()) {
            objectBuilder.add(key, map3.get(key).intValue());
        }
        return objectBuilder.build();
    }
}

