/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.util.metrics.api;

import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.nifi.reporting.util.metrics.api.MetricBuilder;

public class MetricsBuilder {
    static final String ROOT_JSON_ELEMENT = "metrics";
    private final JsonBuilderFactory factory;
    private long timestamp;
    private String applicationId;
    private String instanceId;
    private String hostname;
    private Map<String, String> metrics = new HashMap<String, String>();

    public MetricsBuilder(JsonBuilderFactory factory) {
        this.factory = factory;
    }

    public MetricsBuilder applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public MetricsBuilder instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public MetricsBuilder hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public MetricsBuilder timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public MetricsBuilder metric(String name, String value) {
        this.metrics.put(name, value);
        return this;
    }

    public MetricsBuilder addAllMetrics(Map<String, String> metrics) {
        this.metrics.putAll(metrics);
        return this;
    }

    public JsonObject build() {
        MetricBuilder metricBuilder = new MetricBuilder(this.factory);
        metricBuilder.instanceId(this.instanceId).applicationId(this.applicationId).timestamp(this.timestamp).hostname(this.hostname);
        JsonArrayBuilder metricArrayBuilder = this.factory.createArrayBuilder();
        for (Map.Entry<String, String> entry : this.metrics.entrySet()) {
            metricBuilder.metricName(entry.getKey()).metricValue(entry.getValue());
            metricArrayBuilder.add((JsonValue)metricBuilder.build());
        }
        JsonObjectBuilder metricsBuilder = this.factory.createObjectBuilder();
        metricsBuilder.add(ROOT_JSON_ELEMENT, metricArrayBuilder);
        return metricsBuilder.build();
    }
}

