/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.util.metrics.api;

import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;

public class MetricBuilder {
    private final JsonBuilderFactory factory;
    private String applicationId;
    private String instanceId;
    private String hostname;
    private String timestamp;
    private String metricName;
    private String metricValue;

    public MetricBuilder(JsonBuilderFactory factory) {
        this.factory = factory;
    }

    public MetricBuilder applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public MetricBuilder instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public MetricBuilder hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public MetricBuilder timestamp(long timestamp) {
        this.timestamp = String.valueOf(timestamp);
        return this;
    }

    public MetricBuilder metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public MetricBuilder metricValue(String metricValue) {
        this.metricValue = metricValue;
        return this;
    }

    public JsonObject build() {
        return this.factory.createObjectBuilder().add("metricname", this.metricName).add("appid", this.applicationId).add("instanceid", this.instanceId).add("hostname", this.hostname).add("timestamp", this.timestamp).add("starttime", this.timestamp).add("metrics", this.factory.createObjectBuilder().add(String.valueOf(this.timestamp), this.metricValue)).build();
    }
}

