/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.listen.dispatcher;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.nifi.processor.util.listen.dispatcher.ByteBufferSource;

public class ByteBufferPool
implements ByteBufferSource {
    private final BlockingQueue<ByteBuffer> pool;

    public ByteBufferPool(int poolSize, int bufferSize) {
        if (poolSize <= 0) {
            throw new IllegalArgumentException("A pool of available ByteBuffers is required");
        }
        this.pool = new LinkedBlockingQueue<ByteBuffer>(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            this.pool.offer(ByteBuffer.allocate(bufferSize));
        }
    }

    @Override
    public ByteBuffer acquire() {
        ByteBuffer buffer = (ByteBuffer)this.pool.poll();
        buffer.clear();
        buffer.mark();
        return buffer;
    }

    @Override
    public void release(ByteBuffer byteBuffer) {
        try {
            this.pool.put(byteBuffer);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

