/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.listen;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;

public class ListenerProperties {
    private static final Set<String> interfaceSet = new HashSet<String>();
    public static final PropertyDescriptor NETWORK_INTF_NAME;
    public static final PropertyDescriptor PORT;
    public static final PropertyDescriptor CHARSET;
    public static final PropertyDescriptor RECV_BUFFER_SIZE;
    public static final PropertyDescriptor MAX_SOCKET_BUFFER_SIZE;
    public static final PropertyDescriptor MAX_MESSAGE_QUEUE_SIZE;
    public static final PropertyDescriptor MAX_CONNECTIONS;
    public static final PropertyDescriptor MAX_BATCH_SIZE;
    public static final PropertyDescriptor MESSAGE_DELIMITER;

    static {
        try {
            Enumeration<NetworkInterface> interfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (interfaceEnum.hasMoreElements()) {
                NetworkInterface ifc = interfaceEnum.nextElement();
                interfaceSet.add(ifc.getName());
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        NETWORK_INTF_NAME = new PropertyDescriptor.Builder().name("Local Network Interface").description("The name of a local network interface to be used to restrict listening to a specific LAN.").addValidator(new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                String message;
                ValidationResult result = new ValidationResult.Builder().subject("Local Network Interface").valid(true).input(input).build();
                if (interfaceSet.contains(input.toLowerCase())) {
                    return result;
                }
                String realValue = input;
                try {
                    if (context.isExpressionLanguagePresent(input)) {
                        AttributeExpression ae = context.newExpressionLanguageCompiler().compile(input);
                        realValue = ae.evaluate();
                    }
                    if (interfaceSet.contains(realValue.toLowerCase())) {
                        return result;
                    }
                    message = realValue + " is not a valid network name. Valid names are " + interfaceSet.toString();
                }
                catch (IllegalArgumentException e) {
                    message = "Not a valid AttributeExpression: " + e.getMessage();
                }
                result = new ValidationResult.Builder().subject("Local Network Interface").valid(false).input(input).explanation(message).build();
                return result;
            }
        }).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        PORT = new PropertyDescriptor.Builder().name("Port").description("The port to listen on for communication.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.PORT_VALIDATOR).build();
        CHARSET = new PropertyDescriptor.Builder().name("Character Set").description("Specifies the character set of the received data.").required(true).defaultValue("UTF-8").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();
        RECV_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Receive Buffer Size").description("The size of each buffer used to receive messages. Adjust this value appropriately based on the expected size of the incoming messages.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("65507 B").required(true).build();
        MAX_SOCKET_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Max Size of Socket Buffer").description("The maximum size of the socket buffer that should be used. This is a suggestion to the Operating System to indicate how big the socket buffer should be. If this value is set too low, the buffer may fill up before the data can be read, and incoming data will be dropped.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").required(true).build();
        MAX_MESSAGE_QUEUE_SIZE = new PropertyDescriptor.Builder().name("Max Size of Message Queue").description("The maximum size of the internal queue used to buffer messages being transferred from the underlying channel to the processor. Setting this value higher allows more messages to be buffered in memory during surges of incoming messages, but increases the total memory used by the processor during these surges.").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("10000").required(true).build();
        MAX_CONNECTIONS = new PropertyDescriptor.Builder().name("Max Number of TCP Connections").description("The maximum number of concurrent TCP connections to accept.").addValidator(StandardValidators.createLongValidator((long)1L, (long)65535L, (boolean)true)).defaultValue("2").required(true).build();
        MAX_BATCH_SIZE = new PropertyDescriptor.Builder().name("Max Batch Size").description("The maximum number of messages to add to a single FlowFile. If multiple messages are available, they will be concatenated along with the <Message Delimiter> up to this configured maximum number of messages").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).defaultValue("1").required(true).build();
        MESSAGE_DELIMITER = new PropertyDescriptor.Builder().name("Message Delimiter").displayName("Batching Message Delimiter").description("Specifies the delimiter to place between messages when multiple messages are bundled together (see <Max Batch Size> property).").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("\\n").required(true).build();
    }
}

