/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.list;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.util.list.ListableEntity;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProcessorTestWatcher
extends TestWatcher {
    private static final Logger logger = LoggerFactory.getLogger(ListProcessorTestWatcher.class);
    private static final Consumer<String> logStateDump = arg_0 -> ((Logger)logger).info(arg_0);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final Provider<Map<String, String>> stateMapProvider;
    private final Provider<List<ListableEntity>> entitiesProvider;
    private final Provider<List<FlowFile>> successFlowFilesProvider;
    private long startedAtMillis;

    public ListProcessorTestWatcher(Provider<Map<String, String>> stateMapProvider, Provider<List<ListableEntity>> entitiesProvider, Provider<List<FlowFile>> successFlowFilesProvider) {
        this.stateMapProvider = stateMapProvider;
        this.entitiesProvider = entitiesProvider;
        this.successFlowFilesProvider = successFlowFilesProvider;
    }

    private void log(Consumer<String> dumper, String format, Object ... args) {
        dumper.accept(String.format(format, args));
    }

    public void dumpState(long start) {
        this.dumpState(logStateDump, this.stateMapProvider.provide(), this.entitiesProvider.provide(), this.successFlowFilesProvider.provide(), start);
    }

    private void dumpState(Consumer<String> d, Map<String, String> state, List<ListableEntity> entities, List<FlowFile> flowFiles, long start) {
        long nTime = System.currentTimeMillis();
        this.log(d, "--------------------------------------------------------------------", new Object[0]);
        this.log(d, "%-19s   %-13s %-23s %s", "", "timestamp", "date from timestamp", "t0 delta");
        this.log(d, "%-19s   %-13s %-23s %s", "-------------------", "-------------", "-----------------------", "--------");
        this.log(d, "%-19s = %13d %s %8d", "started at", start, this.dateFormat.format(start), 0);
        this.log(d, "%-19s = %13d %s %8d", "current time", nTime, this.dateFormat.format(nTime), 0);
        this.log(d, "---- processor state -----------------------------------------------", new Object[0]);
        if (state.containsKey("processed.timestamp")) {
            long pTime = Long.parseLong(state.get("processed.timestamp"));
            this.log(d, "%19s = %13d %s %8d", "processed.timestamp", pTime, this.dateFormat.format(pTime), pTime - nTime);
        } else {
            this.log(d, "%19s = na", "processed.timestamp");
        }
        if (state.containsKey("listing.timestamp")) {
            long lTime = Long.parseLong(state.get("listing.timestamp"));
            this.log(d, "%19s = %13d %s %8d", "listing.timestamp", lTime, this.dateFormat.format(lTime), lTime - nTime);
        } else {
            this.log(d, "%19s = na", "listing.timestamp");
        }
        this.log(d, "---- input folder contents -----------------------------------------", new Object[0]);
        entities.sort(Comparator.comparing(ListableEntity::getIdentifier));
        for (ListableEntity entity : entities) {
            this.log(d, "%19s = %12d %s %8d", entity.getIdentifier(), entity.getTimestamp(), this.dateFormat.format(entity.getTimestamp()), entity.getTimestamp() - nTime);
        }
        this.log(d, "---- output flowfiles ----------------------------------------------", new Object[0]);
        Map<String, Long> fileTimes = entities.stream().collect(Collectors.toMap(ListableEntity::getIdentifier, ListableEntity::getTimestamp));
        for (FlowFile ff : flowFiles) {
            String fName = ff.getAttribute(CoreAttributes.FILENAME.key());
            Long fTime = fileTimes.get(fName);
            this.log(d, "%19s = %13d %s %8d", fName, fTime, this.dateFormat.format(fTime), fTime - nTime);
        }
        this.log(d, "REL_SUCCESS count = " + flowFiles.size(), new Object[0]);
        this.log(d, "--------------------------------------------------------------------", new Object[0]);
        this.log(d, "", new Object[0]);
    }

    protected void starting(Description description) {
        this.startedAtMillis = System.currentTimeMillis();
    }

    protected void failed(Throwable e, Description description) {
        if (!(e instanceof AssertionError)) {
            return;
        }
        StringBuilder msg = new StringBuilder("State dump:\n");
        this.dumpState(s -> msg.append((String)s).append("\n"), this.stateMapProvider.provide(), this.entitiesProvider.provide(), this.successFlowFilesProvider.provide(), this.startedAtMillis);
        throw new AssertionError(msg);
    }

    @FunctionalInterface
    public static interface Provider<T> {
        public T provide();
    }
}

