/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.oauth2;

import java.time.Instant;

public class AccessToken {
    private String accessToken;
    private String refreshToken;
    private String tokenType;
    private long expiresIn;
    private String scopes;
    private final Instant fetchTime = Instant.now();

    public AccessToken() {
    }

    public AccessToken(String accessToken, String refreshToken, String tokenType, long expiresIn, String scopes) {
        this();
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.scopes = scopes;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public Instant getFetchTime() {
        return this.fetchTime;
    }

    public boolean isExpired() {
        Instant expirationTime = this.fetchTime.plusSeconds(this.expiresIn);
        return this.now().isAfter(expirationTime);
    }

    Instant now() {
        return Instant.now();
    }
}

