/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.state;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.state.MockStateMap;
import org.junit.jupiter.api.Assertions;

public class MockStateManager
implements StateManager {
    private final AtomicInteger versionIndex = new AtomicInteger(0);
    private StateMap localStateMap = new MockStateMap(null, -1L);
    private StateMap clusterStateMap = new MockStateMap(null, -1L);
    private volatile boolean failToGetLocalState = false;
    private volatile boolean failToSetLocalState = false;
    private volatile boolean failToGetClusterState = false;
    private volatile boolean failToSetClusterState = false;
    private volatile boolean ignoreAnnotations = false;
    private final AtomicLong localRetrievedCount = new AtomicLong(0L);
    private final AtomicLong clusterRetrievedCount = new AtomicLong(0L);
    private final boolean usesLocalState;
    private final boolean usesClusterState;
    private ExecutionMode executionMode = ExecutionMode.CLUSTERED;

    public MockStateManager(Object component) {
        Stateful stateful = component.getClass().getAnnotation(Stateful.class);
        if (stateful == null) {
            this.usesLocalState = false;
            this.usesClusterState = false;
        } else {
            Scope[] scopes = stateful.scopes();
            boolean local = false;
            boolean cluster = false;
            for (Scope scope : scopes) {
                if (scope == Scope.LOCAL) {
                    local = true;
                    continue;
                }
                if (scope != Scope.CLUSTER) continue;
                cluster = true;
            }
            this.usesLocalState = local;
            this.usesClusterState = cluster;
        }
    }

    public void reset() {
        this.clusterStateMap = new MockStateMap(null, -1L);
        this.localStateMap = new MockStateMap(null, -1L);
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public synchronized void setState(Map<String, String> state, Scope scope) throws IOException {
        this.verifyAnnotation(scope);
        this.verifyCanSet(scope);
        MockStateMap stateMap = new MockStateMap(state, this.versionIndex.incrementAndGet());
        if (scope == Scope.CLUSTER && this.executionMode == ExecutionMode.CLUSTERED) {
            this.clusterStateMap = stateMap;
        } else {
            this.localStateMap = stateMap;
        }
    }

    public synchronized StateMap getState(Scope scope) throws IOException {
        this.verifyAnnotation(scope);
        this.verifyCanGet(scope);
        return this.retrieveState(scope);
    }

    private synchronized StateMap retrieveState(Scope scope) {
        this.verifyAnnotation(scope);
        if (scope == Scope.CLUSTER) {
            this.clusterRetrievedCount.incrementAndGet();
            return this.executionMode == ExecutionMode.CLUSTERED ? this.clusterStateMap : this.localStateMap;
        }
        this.localRetrievedCount.incrementAndGet();
        return this.localStateMap;
    }

    public long getRetrievalCount(Scope scope) {
        return switch (scope) {
            default -> throw new MatchException(null, null);
            case Scope.CLUSTER -> this.clusterRetrievedCount.get();
            case Scope.LOCAL -> this.localRetrievedCount.get();
        };
    }

    public synchronized boolean replace(StateMap oldValue, Map<String, String> newValue, Scope scope) throws IOException {
        this.verifyAnnotation(scope);
        if (scope == Scope.CLUSTER) {
            if (this.executionMode == ExecutionMode.CLUSTERED && oldValue == this.clusterStateMap) {
                this.verifyCanSet(scope);
                this.clusterStateMap = new MockStateMap(newValue, this.versionIndex.incrementAndGet());
                return true;
            }
            if (this.executionMode == ExecutionMode.STANDALONE && oldValue == this.localStateMap) {
                this.verifyCanSet(scope);
                this.localStateMap = new MockStateMap(newValue, this.versionIndex.incrementAndGet());
                return true;
            }
            return false;
        }
        if (oldValue == this.localStateMap) {
            this.verifyCanSet(scope);
            this.localStateMap = new MockStateMap(newValue, this.versionIndex.incrementAndGet());
            return true;
        }
        return false;
    }

    public synchronized void clear(Scope scope) throws IOException {
        this.verifyAnnotation(scope);
        this.setState(Collections.emptyMap(), scope);
    }

    private void verifyCanSet(Scope scope) throws IOException {
        boolean failToSet;
        boolean bl = failToSet = scope == Scope.LOCAL ? this.failToSetLocalState : this.failToSetClusterState;
        if (failToSet) {
            throw new IOException("Unit Test configured to throw IOException if " + String.valueOf(scope) + " State is set");
        }
    }

    private void verifyCanGet(Scope scope) throws IOException {
        boolean failToGet;
        boolean bl = failToGet = scope == Scope.LOCAL ? this.failToGetLocalState : this.failToGetClusterState;
        if (failToGet) {
            throw new IOException("Unit Test configured to throw IOException if " + String.valueOf(scope) + " State is retrieved");
        }
    }

    public void setIgnoreAnnotations(boolean ignore) {
        this.ignoreAnnotations = ignore;
    }

    private void verifyAnnotation(Scope scope) {
        if (this.ignoreAnnotations) {
            return;
        }
        if (scope == Scope.LOCAL && !this.usesLocalState || scope == Scope.CLUSTER && !this.usesClusterState) {
            Assertions.fail((String)("Component is attempting to set or retrieve state with a scope of " + String.valueOf(scope) + " but does not declare that it will use " + String.valueOf(scope) + " state. A @Stateful annotation should be added to the component with a scope of " + String.valueOf(scope)));
        }
    }

    private String getValue(String key, Scope scope) {
        StateMap stateMap = scope == Scope.CLUSTER && this.executionMode == ExecutionMode.CLUSTERED ? this.clusterStateMap : this.localStateMap;
        return stateMap.get(key);
    }

    public void assertStateEquals(String key, String value, Scope scope) {
        Assertions.assertEquals((Object)value, (Object)this.getValue(key, scope));
    }

    public void assertStateEquals(Map<String, String> stateValues, Scope scope) {
        StateMap stateMap = this.retrieveState(scope);
        Assertions.assertEquals(stateValues, (Object)stateMap.toMap());
    }

    public void assertStateNotEquals(Map<String, String> stateValues, Scope scope) {
        StateMap stateMap = this.retrieveState(scope);
        Assertions.assertNotSame(stateValues, (Object)stateMap.toMap());
    }

    public void assertStateNotEquals(String key, String value, Scope scope) {
        Assertions.assertNotEquals((Object)value, (Object)this.getValue(key, scope));
    }

    public void assertStateSet(String key, Scope scope) {
        Assertions.assertNotNull((Object)this.getValue(key, scope), (String)("Expected state to be set for key " + key + " and scope " + String.valueOf(scope) + ", but it was not set"));
    }

    public void assertStateNotSet(String key, Scope scope) {
        Assertions.assertNull((Object)this.getValue(key, scope), (String)("Expected state not to be set for key " + key + " and scope " + String.valueOf(scope) + ", but it was set"));
    }

    public void assertStateSet(Scope scope) {
        StateMap stateMap = scope == Scope.CLUSTER ? this.clusterStateMap : this.localStateMap;
        Assertions.assertTrue((boolean)stateMap.getStateVersion().isPresent(), (String)("Expected state to be set for Scope " + String.valueOf(scope) + ", but it was not set"));
    }

    public void assertStateNotSet() {
        this.assertStateNotSet(Scope.CLUSTER);
        this.assertStateNotSet(Scope.LOCAL);
    }

    public void assertStateNotSet(Scope scope) {
        StateMap stateMap = scope == Scope.CLUSTER ? this.clusterStateMap : this.localStateMap;
        Assertions.assertFalse((boolean)stateMap.getStateVersion().isPresent(), (String)("Expected state not to be set for Scope " + String.valueOf(scope) + ", but it was set"));
    }

    public void setFailOnStateSet(Scope scope, boolean fail) {
        if (scope == Scope.LOCAL) {
            this.failToSetLocalState = fail;
        } else {
            this.failToSetClusterState = fail;
        }
    }

    public void setFailOnStateGet(Scope scope, boolean fail) {
        if (scope == Scope.LOCAL) {
            this.failToGetLocalState = fail;
        } else {
            this.failToGetClusterState = fail;
        }
    }

    public static enum ExecutionMode {
        CLUSTERED,
        STANDALONE;

    }
}

