/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EqualsWrapper<T> {
    private final T item;
    private final List<Function<T, Object>> propertyProviders;

    public EqualsWrapper(T item, List<Function<T, Object>> propertyProviders) {
        this.item = item;
        this.propertyProviders = propertyProviders;
    }

    public static <T> List<EqualsWrapper<T>> wrapList(Collection<T> items, List<Function<T, Object>> propertyProviders) {
        List<EqualsWrapper<T>> wrappers = items.stream().map(item -> new EqualsWrapper<Object>(item, propertyProviders)).collect(Collectors.toList());
        return wrappers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !Arrays.equals(o.getClass().getGenericInterfaces(), o.getClass().getGenericInterfaces())) {
            return false;
        }
        EqualsWrapper that = (EqualsWrapper)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        for (Function<T, Object> propertyProvider : this.propertyProviders) {
            equalsBuilder.append(propertyProvider.apply(this.item), propertyProvider.apply(that.item));
        }
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(17, 37);
        for (Function<T, Object> propertyProvider : this.propertyProviders) {
            hashCodeBuilder.append(propertyProvider.apply(this.item));
        }
        return hashCodeBuilder.toHashCode();
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(",\n\t", "{\n\t", "\n}");
        for (Function<T, Object> propertySupplier : this.propertyProviders) {
            stringJoiner.add(Optional.ofNullable(propertySupplier.apply(this.item)).orElse("N/A").toString());
        }
        return stringJoiner.toString();
    }
}

