/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SerializationUtils;

abstract class MessageBodyToBytesConverter {
    MessageBodyToBytesConverter() {
    }

    public static byte[] toBytes(TextMessage message) {
        return MessageBodyToBytesConverter.toBytes(message, null);
    }

    public static byte[] toBytes(TextMessage message, Charset charset) {
        try {
            if (message.getText() == null) {
                return new byte[0];
            }
            if (charset == null) {
                return message.getText().getBytes();
            }
            return message.getText().getBytes(charset);
        }
        catch (JMSException e) {
            throw new MessageConversionException("Failed to convert " + TextMessage.class.getSimpleName() + " to byte[]", e);
        }
    }

    public static byte[] toBytes(BytesMessage message) {
        try {
            BytesMessageInputStream is = new BytesMessageInputStream(message);
            return IOUtils.toByteArray((InputStream)is);
        }
        catch (Exception e) {
            throw new MessageConversionException("Failed to convert " + BytesMessage.class.getSimpleName() + " to byte[]", e);
        }
    }

    public static byte[] toBytes(ObjectMessage message) {
        try {
            return SerializationUtils.serialize((Serializable)message.getObject());
        }
        catch (Exception e) {
            throw new MessageConversionException("Failed to convert " + ObjectMessage.class.getSimpleName() + " to byte[]", e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] toBytes(StreamMessage message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(MapMessage message) {
        ObjectMapper objectMapper = new ObjectMapper();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] jsonAsByteArray;
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            Enumeration mapNames = message.getMapNames();
            while (mapNames.hasMoreElements()) {
                String name = (String)mapNames.nextElement();
                Object value = message.getObject(name);
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    ArrayList<Byte> byteList = new ArrayList<Byte>(bytes.length);
                    for (byte aByte : bytes) {
                        byteList.add(aByte);
                    }
                    objectMap.put(name, byteList);
                    continue;
                }
                objectMap.put(name, value);
            }
            objectMapper.writeValue((OutputStream)byteArrayOutputStream, objectMap);
            byte[] byArray = jsonAsByteArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (JMSException e) {
            throw new MessageConversionException("Couldn't read incoming " + MapMessage.class.getSimpleName(), e);
        }
        catch (IOException e) {
            throw new MessageConversionException("Couldn't transform incoming " + MapMessage.class.getSimpleName() + " to JSON", e);
        }
    }

    static class MessageConversionException
    extends RuntimeException {
        private static final long serialVersionUID = -1464448549601643887L;

        public MessageConversionException(String msg) {
            super(msg);
        }

        public MessageConversionException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class BytesMessageInputStream
    extends InputStream {
        private BytesMessage message;

        public BytesMessageInputStream(BytesMessage message) {
            this.message = message;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.message.readByte();
            }
            catch (JMSException e) {
                throw new IOException(e.toString());
            }
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                if (offset == 0) {
                    return this.message.readBytes(buffer, length);
                }
                return super.read(buffer, offset, length);
            }
            catch (JMSException e) {
                throw new IOException(e.toString());
            }
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            try {
                return this.message.readBytes(buffer);
            }
            catch (JMSException e) {
                throw new IOException(e.toString());
            }
        }
    }
}

