/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.hbase.DeleteRequest;
import org.apache.nifi.hbase.put.PutColumn;
import org.apache.nifi.hbase.put.PutFlowFile;
import org.apache.nifi.hbase.scan.Column;
import org.apache.nifi.hbase.scan.ResultHandler;

@Tags(value={"hbase", "client"})
@CapabilityDescription(value="A controller service for accessing an HBase client.")
public interface HBaseClientService
extends ControllerService {
    public void put(String var1, Collection<PutFlowFile> var2) throws IOException;

    public void put(String var1, byte[] var2, Collection<PutColumn> var3) throws IOException;

    public boolean checkAndPut(String var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, PutColumn var6) throws IOException;

    public void delete(String var1, byte[] var2) throws IOException;

    public void delete(String var1, byte[] var2, String var3) throws IOException;

    public void delete(String var1, List<byte[]> var2) throws IOException;

    public void deleteCells(String var1, List<DeleteRequest> var2) throws IOException;

    public void delete(String var1, List<byte[]> var2, String var3) throws IOException;

    public void scan(String var1, Collection<Column> var2, String var3, long var4, ResultHandler var6) throws IOException;

    public void scan(String var1, Collection<Column> var2, String var3, long var4, List<String> var6, ResultHandler var7) throws IOException;

    public void scan(String var1, byte[] var2, byte[] var3, Collection<Column> var4, List<String> var5, ResultHandler var6) throws IOException;

    public void scan(String var1, String var2, String var3, String var4, Long var5, Long var6, Integer var7, Boolean var8, Collection<Column> var9, List<String> var10, ResultHandler var11) throws IOException;

    public byte[] toBytes(boolean var1);

    public byte[] toBytes(float var1);

    public byte[] toBytes(int var1);

    public byte[] toBytes(long var1);

    public byte[] toBytes(double var1);

    public byte[] toBytes(String var1);

    public byte[] toBytesBinary(String var1);

    default public String toTransitUri(String tableName, String rowKey) {
        return "hbase://" + tableName + (rowKey != null && !rowKey.isEmpty() ? "/" + rowKey : "");
    }
}

