/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.nar.NarAutoLoaderTask;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.FileUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarAutoLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NarAutoLoader.class);
    private static final long POLL_INTERVAL_MS = 5000L;
    private final NiFiProperties properties;
    private final NarLoader narLoader;
    private volatile NarAutoLoaderTask narAutoLoaderTask;
    private volatile boolean started = false;

    public NarAutoLoader(NiFiProperties properties, NarLoader narLoader) {
        this.properties = Objects.requireNonNull(properties);
        this.narLoader = Objects.requireNonNull(narLoader);
    }

    public synchronized void start() throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException, TlsException {
        if (this.started) {
            return;
        }
        File autoLoadDir = this.properties.getNarAutoLoadDirectory();
        FileUtils.ensureDirectoryExistAndCanRead((File)autoLoadDir);
        List<File> initialNars = Arrays.asList(autoLoadDir.listFiles((dir, name) -> name.endsWith(".nar") && !name.startsWith(".")));
        LOGGER.info("Found {} initial NARs from directory {}", (Object)initialNars.size(), (Object)autoLoadDir.getName());
        if (!initialNars.isEmpty()) {
            LOGGER.info("Loading initial NARs from directory {}...", (Object)autoLoadDir.getName());
            this.narLoader.load(initialNars);
        }
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path autoLoadPath = autoLoadDir.toPath();
        autoLoadPath.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        this.narAutoLoaderTask = new NarAutoLoaderTask.Builder().autoLoadPath(autoLoadPath).watchService(watcher).pollIntervalMillis(5000L).narLoader(this.narLoader).build();
        LOGGER.info("Starting NAR Auto-Loader Thread for directory {} ...", new Object[]{autoLoadPath});
        Thread autoLoaderThread = new Thread(this.narAutoLoaderTask);
        autoLoaderThread.setName("NAR Auto-Loader");
        autoLoaderThread.setDaemon(true);
        autoLoaderThread.start();
    }

    public synchronized void stop() {
        this.started = false;
        if (this.narAutoLoaderTask != null) {
            this.narAutoLoaderTask.stop();
            this.narAutoLoaderTask = null;
        }
        LOGGER.info("NAR Auto-Loader stopped");
    }
}

